<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Appendix to Contract - Interior Works for Upper Ground Floor</title>
    <style>
        body {

            line-height: 1.6;
            margin: 0;
            padding: 20px;
            color: #333;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .project-title {
            font-weight: bold;
            margin-bottom: 20px;
            text-align: center;
        }

        .page-info {
            text-align: right;
            font-size: 0.9em;
            margin-bottom: 20px;
        }

        .contract-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        .contract-table th,
        .contract-table td {
            border: 1px solid #ddd;
            padding: 8px;
            vertical-align: top;
        }

        .contract-table th {
            background-color: #f2f2f2;
            font-weight: bold;
            text-align: left;
        }

        .clause-number {
            font-weight: bold;
        }

        .highlight {
            font-weight: bold;
        }

        .underline {
            text-decoration: underline;
        }

        .indented {
            margin-left: 20px;
        }

        .nested-list {
            margin-left: 40px;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 0.9em;
            color: #666;
        }

        .section-break {
            page-break-before: always;
        }
    </style>
</head>

<body>
    <div id="wrapper">
        <div class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="panel_s">
                        <div class="panel-body">
                            <div class="header">
                                <div class="project-title">Interior Works for Upper Ground Floor for Guest House Project at Jamnagar</div>
                            </div>

                            <div class="page-info">ABH-LOA-AC-UGF-ID-017-R0</div>

                            <p>The Conditions of Contract comprise the "<strong>General Conditions</strong>", which form part of the "<strong>Conditions of Contract for Construction for Building and Engineering Works designed by the Employer"; Second Edition 2017 published by the Federation Internationale des Ingénieurs-Conseils (FIDIC)</strong> shall be applicable for this Contract. The Contractor is deemed to be acquainted with and shall be in possession of the "General Conditions".</p>

                            <p><strong>Particular Conditions Part A - Contract Data</strong></p>

                            <table class="contract-table">
                                <thead>
                                    <tr>
                                        <th>Clause</th>
                                        <th>Particulars</th>
                                        <th>Data</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="clause-number">Clause 1.0</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.1.27</td>
                                        <td>Defect Notification period (DNP)</td>
                                        <td>365 days (after issuing Taking-Over Certificate)</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.1.31</td>
                                        <td>Employer's name and Address:</td>
                                        <td>
                                            <strong>M/s. Basillus International LLP,</strong><br>
                                            3rd Floor, 304, Benison Commercial Complex, Old Padra Road,<br>
                                            Opposite Hari Bhakti,<br>
                                            Vadodara, Gujarat -- 390007
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.1.35</td>
                                        <td>Engineers Name and Address:</td>
                                        <td>NA</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.1.85</td>
                                        <td>Time of completion:</td>
                                        <td><span class="highlight">On before 30<sup>th</sup> November' 2023.</span></td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.3.(a)(ii)</td>
                                        <td>Agreed method of electronic transmission:</td>
                                        <td>e-mail</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.3(d)</td>
                                        <td>Address of Employer for communication:</td>
                                        <td>
                                            <a href="mailto:shikhar@basilius.in" class="underline">shikhar@basilius.in</a>,
                                            <a href="mailto:abh.project@basilus.in">abh.project@basilus.in</a>;
                                            <a href="mailto:abhishek.intodia@basilius.in">abhishek.intodia@basilius.in</a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.3(d)</td>
                                        <td>Address of engineer for communication:</td>
                                        <td><a href="mailto:qs@basilius.in">qs@basilius.in</a></td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.4</td>
                                        <td>Contract shall be governed by the law of:</td>
                                        <td>Republic of India</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.4</td>
                                        <td>Ruling Language:</td>
                                        <td>English</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.4</td>
                                        <td>Language for communication:</td>
                                        <td>English</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">1.8</td>
                                        <td>Numbers of additional paper copies of contractor's document</td>
                                        <td>Two</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">2.1</td>
                                        <td>After receiving the LOA, the contractor shall be given right of access to all or part of the site with in</td>
                                        <td>Immediate</td>
                                    </tr>

                                    <tr>
                                        <td class="clause-number">2.4</td>
                                        <td>Employer financial arrangement</td>
                                        <td>Not applicable</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">4.2</td>
                                        <td>Performance Security (as percentage of the accepted Contract Amount in currencies and validity)</td>
                                        <td>
                                            <div><strong>Percentage:</strong> 5% INR</div>
                                            <div><strong>Validity:</strong> Up to 90 days after successful completion of Defect Liability Period</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">4.19</td>
                                        <td>Electricity, Water & Gas</td>
                                        <td>
                                            <p><strong>Electricity:</strong> Electricity shall be arranged by Employer at one point only on chargeable basis. Further distribution will be done by contractor at his cost.</p>
                                            <p>Recovery of electricity charges will be done @ charges billed by the service provider / local authority.</p>
                                            <p>Contractor is required to install sub meter and maintain daily power consumption record. The record shall be made available as and when required.</p>
                                            <p>Employer does not Guarantee full time power supply from the grid, Hence In case of non-availability of electricity, contractor should make alternate arrangement for power backup such as DG etc. at his own cost to complete the work in stipulated time period.</p>
                                            <p><strong>Water:</strong> Construction water shall be arranged by Employer at one point, distribution network, pumps and storage tanks etc. should be arranged by contractor at his own cost. In case of unavailability of sufficient water, the additional requirement has to be made by contractor at their own risk & cost with all required arrangements.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">4.7.2</td>
                                        <td>Period for notification of errors in the items of reference:</td>
                                        <td>7 days</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">4.19</td>
                                        <td>Period of payment for temporary utilities</td>
                                        <td>Each month</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">4.20</td>
                                        <td>Employer's free-issue material</td>
                                        <td>As per Item BOQ</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">4.20</td>
                                        <td>Number of additional copies of progress reports</td>
                                        <td>Two</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">5.1(b)</td>
                                        <td>Subcontracting</td>
                                        <td>No allowed.</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">6.5</td>
                                        <td>Normal working hours on the site</td>
                                        <td>8.00 am to 10.00 pm</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">6.6</td>
                                        <td>Facility for Staff & Labour</td>
                                        <td>
                                            <p>Only space shall be provided to the contractor for temporary construction of store and office.</p>
                                            <p>Accommodation facility for labour and staff shall not be permitted at site.</p>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td class="clause-number">6.6</td>
                                        <td>Key Personnel</td>
                                        <td>
                                            <ol>
                                                <li>Project Manager</li>
                                                <li>Planning Engineer</li>
                                                <li>Billing Engineer</li>
                                                <li>QA & QC Engineer</li>
                                                <li>Plant & Machinery In-Charge</li>
                                                <li>EHS In-Charge</li>
                                                <li>Storekeeper</li>
                                            </ol>
                                            <p>All other staff as per approved organization structure by Engineer as required to complete the work as per schedule.</p>
                                            <p>Appointment of Contractor's Project Manager & Construction manager will require Engineer approval.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">8.3</td>
                                        <td>Programme</td>
                                        <td>
                                            <p>The proposed execution schedule shall be enclosed by the bidder in schedule (Key Milestone level) in a format of project management tools like (MS Project (preferred) or Primavera) along with tender submission. Within 30 days of receiving the Notice to Proceed / LOA (whichever is earlier), the Contractor shall submit a detailed construction schedule in the same software tools.</p>
                                            <p>Whilst the activities and the duration of activities may differ from those identified on the Employer's schedule, however, the Employer will not change the dates for achieving major milestones and the completion date of tendered work.</p>
                                            <p>Month wise planned vs. achieved, MSP tracking resource planning showing deployment of labour and machinery along with detail work breakdown structure (WBS) to be submitted before 28th of preceding month for next month. Daily, weekly, fortnightly monitoring reports to be submitted to Engineer / Employer in approved formats. Any other additional requirement shall be fulfilled without any extra cost.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">8.3</td>
                                        <td>Number of additional paper copies of program</td>
                                        <td>Two</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">8.8</td>
                                        <td>Milestones, Sectional completion</td>
                                        <td>
                                            <p>Refer to Key Milestone dates mentioned in clause 1.1.85.</p>
                                            <p>Delay damages shall be 1% of the final Contract Price per week in the currencies and proportions subjected to a maximum of 5%.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">8.8</td>
                                        <td>Delay damage payable for each week of delay</td>
                                        <td>Delay damages shall be 1% of the final Contract Price per week in the currencies and proportions subjected to a maximum of 5%.</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">8.8</td>
                                        <td>Maximum amount of delay damages</td>
                                        <td>
                                            <p>5% of total contract sum.</p>
                                            <p><strong>Additional Paragraphs:</strong></p>
                                            <p>If the Contractor fails to achieve any of the milestones indicated in Contractor's program under Sub-Clause 8.3 or as specified in the Appendix to Tender, the Employer Representative may withhold temporary amounts from the Contractor's payments, at the rate indicated in the Appendix to Tender applied to the Section of the Works which is delayed. This retention shall be released as soon as the Contractor achieves the subsequent milestones within the specified time, otherwise this retention shall be treated as part of the delay damages paid to the Employer under this Sub- Clause.</p>
                                            <p>If the Works are to be completed in Sections within the respective time specified in the Appendix to Tender, then the Contractor shall pay delay damages to the Employer for any delay in completing the respective Sections of the Works at the rate specified in the Appendix to Tender applied to the value of the works delayed.</p>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td class="clause-number">12.2</td>
                                        <td>Method of measurement</td>
                                        <td>As per IS</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">13.4(b)(ii)</td>
                                        <td>Percentage rate to be applied to Provisional Sums for overhead charges and profit</td>
                                        <td>Clause deleted</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">13.8</td>
                                        <td>Adjustment for change in Cost</td>
                                        <td>
                                            <ol>
                                                <li>No escalation shall be payable on account of price change for any material, labour or any other reason whatsoever, during the contract period or extended period of contract till completion of work.</li>
                                                <li>The Prime Cost for procurement has been specified for the following materials as per Bill of quantities
                                                    <ul class="nested-list">
                                                        <li>WOOVEN VINYL flooring</li>
                                                        <li>Kota Stone</li>
                                                        <li>Granite Stone</li>
                                                        <li>Ceramic Tile</li>
                                                    </ul>
                                                </li>
                                            </ol>
                                            <p>The increase/ decrease in cost due to variation of actual procurement rates shall be adjusted.</p>
                                            <p>Escalation on any other item except prime rate shall not be payable, whatsoever the reasons. Contractor should include the escalation amount for items other than prime rate in their quoted price.</p>
                                        </td>
                                    </tr>
                                
                                    <tr>
                                        <td class="clause-number">14.2</td>
                                        <td>Total amount of advance payment (as a percentage of Accepted Contract Amount)</td>
                                        <td>
                                            <p>10% of the contract value (Without GST and Labour Cess) shall be paid to the contractor as mobilization advance. The first instalment of 5% shall be released after submission of Bank Guarantee and the second instalment of balance 5% shall be released after full mobilization at site.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.2.3</td>
                                        <td>Percentage deductions for the repayment of advance payment</td>
                                        <td>100% Advance shall be recovered from 1<sup>st</sup> RA bills prior to 75% of Total work done value on pro rata basis.</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.3</td>
                                        <td>Period of payment (submission of IPC for the work done in last month)</td>
                                        <td>
                                            <p>On 5th Working day of every month Payment Terms:</p>
                                            <p><strong>Fixed Finishes:</strong></p>
                                            <ul class="nested-list">
                                                <li>75% of item rate on prorate basis against installation.</li>
                                                <li>15% of item rate on prorate basis against final finishing.</li>
                                                <li>10% of item rate on prorate basis against handing over.</li>
                                            </ul>
                                            <p><strong>Mill works and doors:</strong></p>
                                            <ul class="nested-list">
                                                <li>50% on prorate basis against installation of carcass / structure before finishing at factory.</li>
                                                <li>15% on prorate basis against installation of material of carcass / structure.</li>
                                                <li>25% on a prorate basis against fixing of hardware and final finishings.</li>
                                                <li>10% on prorate basis against handing over.</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.3(b)</td>
                                        <td>Numbers of additional paper copies of statements</td>
                                        <td>Two</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.3(iii)</td>
                                        <td>Percentage of retention</td>
                                        <td>
                                            <p>5% of work done value shall be deducted from each RA bill towards the obligation of defect liability period.</p>
                                            <p>Retention shall be released after successful completion of Defect Notification Period.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.3(iii)</td>
                                        <td>Limit of retention money (as per percentage of Accepted Contract Amount)</td>
                                        <td>5%</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.5(b)9i)</td>
                                        <td>Plant and Materials for payment when shipped</td>
                                        <td>Not Applicable</td>
                                    </tr>
                                
                                    <tr>
                                        <td class="clause-number">14.5(c)(i)</td>
                                        <td>Plant and Materials for payment when delivered at site</td>
                                        <td>Not Applicable</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.6.2</td>
                                        <td>Minimum amount of Payment Certificate (IPC)</td>
                                        <td>Interim payments on monthly on achieving min valuation INR 1,00,00,000/- except first two RA bills.</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.7(a)</td>
                                        <td>Period of payment of Advance Payment to contractor</td>
                                        <td>As per LOA</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.7(b)(i)</td>
                                        <td>Period for the Employer to make interim payments to the contractor under sub-Clause 14.6 [Interim Payment]</td>
                                        <td>
                                            <p>An ad-hoc amount of 65% of net value of running account bill shall be paid within 21 days from the date of submission of bill in all respect. The balance of 35% shall be paid within 30 days from the date of certification of bill.</p>
                                            <p>However, if there is a reduction of more than 5% in the billed amount Vs actual amounts, then the system of ad hoc payment would be discontinued from the next RA bill onwards.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.7(b)(ii)</td>
                                        <td>Period for the Employer to make interim payments to the contractor under sub-Clause 14.13 [Final Payment]</td>
                                        <td>90 days after certification from Engineer.</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.7(c)</td>
                                        <td>Period for the employer to make final payments to the Contractor</td>
                                        <td>90 days</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.8</td>
                                        <td>Financing charges for delayed payment (percentage points above the average bank short-term lending rate as referred to under sub-paragraph (a))</td>
                                        <td>Not Applicable</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.11(b)</td>
                                        <td>Number of additional paper copies of draft Final Statement</td>
                                        <td>Three</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.15</td>
                                        <td>Currencies for payment of contract Price</td>
                                        <td>INR</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.15(a)(i)</td>
                                        <td>Proportion or amount of Local and Foreign Currencies are:
                                            <ul class="nested-list">
                                                <li>Local</li>
                                                <li>Foreign</li>
                                            </ul>
                                        </td>
                                        <td>
                                            <div>100%</div>
                                            <div>Nil</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.15(c)</td>
                                        <td>Currencies and proportion for payment of Delay Damages</td>
                                        <td>INR, 100%</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">14.15(f)</td>
                                        <td>Rate of exchange</td>
                                        <td>Not Applicable</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">17.2(d)</td>
                                        <td>Forces of nature, the risks of which are allocated to the contractor</td>
                                        <td>Not Applicable</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">19.2(1)(b)</td>
                                        <td>Additional amount to be insured (as a percentage of the replacement value, if less or more than 15%)</td>
                                        <td>Not applicable</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">19.2(1)(iv)</td>
                                        <td>List of Exceptional Risks which shall not be excluded from the insurance cover for the Work</td>
                                        <td>Not applicable</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">19.2.3</td>
                                        <td>Period of insurance required for liability for breach of professional duty</td>
                                        <td>Not applicable</td>
                                    </tr>
                                
                                    <tr>
                                        <td class="clause-number">19.2.4</td>
                                        <td>Amount of insurance required for injury to person and damaged to property</td>
                                        <td>As per the law of land.</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">19.2.6</td>
                                        <td>Other insurance required by laws and by local practice</td>
                                        <td>As per law of Republic of INDIA</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">15.5</td>
                                        <td>Employer's Entitlement to Termination</td>
                                        <td>
                                            <p>Employer reserve the right to foreclose the works.</p>
                                            <p>If this clause is exercised at a stage where the work executed is up to 50% of the contract value, then the foreclosure cost payable to Contractor shall be mutually discussed and agreed cost. If the executed contract value is 50% or more, then 1% of the remaining contract value shall be paid as Foreclosure cost to Contractor.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">18.1</td>
                                        <td>Contractors All Risk Policy</td>
                                        <td>Contractor Scope</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">18.2</td>
                                        <td>Insurance for Contractor Equipment</td>
                                        <td>Contractor Scope</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">18.3</td>
                                        <td>Insurance for Workmen's Compensation Act</td>
                                        <td>Contractor Scope</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">18.3 & 18.4</td>
                                        <td>Maximum amount of third party Insurance.</td>
                                        <td>
                                            <p>Insurance to be taken in the joint names of the Employer and the Contractor (being the Principal Beneficiary) against such risks, before commencement of the Works. The minimum limit of the coverage under the Policy shall be Rs 50.00 Lakhs per accident or occurrence, there being no limit on the number of such accidents or occurrences.</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">21.1</td>
                                        <td>Time of appointment of Dispute Avoidance /Adjudication Board</td>
                                        <td>28 days</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">21.1</td>
                                        <td>The DAAB shall comprise</td>
                                        <td>Three members</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">21.1</td>
                                        <td>List of proposed members of DAAB
                                            <ul class="nested-list">
                                                <li>Proposed by employer</li>
                                                <li>Proposed by contractor</li>
                                            </ul>
                                        </td>
                                        <td>
                                            <div>TBD</div>
                                            <div>TBD</div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">21.2</td>
                                        <td>Appointing entity (official) for DAAB members</td>
                                        <td>Employer</td>
                                    </tr>
                                    <tr>
                                        <td class="clause-number">15.3</td>
                                        <td>Arbitration: Rule Place of Arbitration</td>
                                        <td>Arbitration and conciliation act 1996 Mumbai</td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Labour cess</td>
                                        <td>Labour cess shall be paid extra.</td>
                                    </tr>
                                </tbody>
                            </table>

                            <div class="footer">
                                <p>Document: Appendix to Contract - Interior Works for Upper Ground Floor</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <?php init_tail(); ?>
</body>

</html>