<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>


<head>
    <meta charset="utf-8" />
    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
    <title>
        Environmental Health &amp; Safety Manual
    </title>
    <style>
        /* body {
            font-family: 'Times New Roman', serif;
            margin: 60px;
            line-height: 1.6;
            color: #222;
        } */

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            text-transform: uppercase;
            margin-top: 30px;
        }

        h1 {
            font-size: 28px;
            text-align: center;
        }

        h2 {
            font-size: 22px;
        }

        h3 {
            font-size: 18px;
        }

        p {
            margin: 8px 0;
        }

        a {
            text-decoration: none;
            color: #004080;
        }

        a:hover {
            text-decoration: underline;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin: 20px 0;
        }

        th,
        td {
            border: 1px solid #aaa;
            padding: 6px 10px;
        }

        .toc {
            margin-bottom: 40px;
        }

        .toc h2 {
            text-align: center;
            margin-bottom: 15px;
        }

        .page-break {
            page-break-after: always;
        }

        ol {
            list-style: decimal;
        }
    </style>
</head>


<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <header>
                            <h1>
                                Environmental, Health &amp; Safety Manual
                            </h1>
                            <p style="text-align:center;">
                                <i>
                                    Issued for Tenders &amp; Construction
                                </i>
                            </p>
                        </header>
                        <section class="toc">
                            <h2>
                                Table of Contents
                            </h2>
                            <a href="#section-1">
                                TABLE OF CONTENTS
                            </a>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-2">
                                    GENERAL PROVISIONS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-3">
                                    Introduction
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-4">
                                    Purpose
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-5">
                                    Scope
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-6">
                                    Selection of sub-contractor
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-7">
                                    Standards and References
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-8">
                                    ELEMENTS OF CONSTRUCTION SAFETY
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-9">
                                    Contractor’s basic responsibility
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-10">
                                    Site Rule and Discipline:
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-11">
                                    Planning and Coordination
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-12">
                                    Monitoring
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-13">
                                    Records
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-14">
                                    Non Compliance with Safety and Health Provisions
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-15">
                                    Disciplinary action
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-16">
                                    SAFETY ORGANISATION
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-17">
                                    Duties of contractor’s Project Manager.
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-18">
                                    Duties of contractor’s Safety Manager.
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-19">
                                    Duties of contractor’s Site Engineers and supervisors
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-20">
                                    Duties of Contractor’s Employees &amp; Labour
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-21">
                                    SAFETY COMMITTEE
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-22">
                                    Objectives of Safety Committees:
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-23">
                                    Functions of Department Safety Committees:
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-24">
                                    SAFETY INDUCTION AND TRAINING
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-25">
                                    Objectives of Safety Induction and Training
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-26">
                                    Site Specific Induction
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-27">
                                    COMMUNICATION &amp; MEETINGS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-28">
                                    Bi Weekly management Safety meeting.
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-29">
                                    Weekly Tool box meetings
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-30">
                                    Emergency Safety Meeting
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-31">
                                    SAFETY INSPECTIONS AND REPORTS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-32">
                                    Daily Safety inspection
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-33">
                                    Weekly Safety Walk around
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-34">
                                    Contractor’s Monthly Safety Report
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-35">
                                    WORK PERMITS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-36">
                                    PERSONNEL PROTECTION
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-37">
                                    ACCIDENT PREVENTION, REPORTING AND INVESTIGATION
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-38">
                                    Incidents &amp; accidents
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-39">
                                    Accident Investigation
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-40">
                                    Near Miss
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-41">
                                    Recommended actions in investigation
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-42">
                                    ACCIDENT STATISTICS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-43">
                                    HOUSEKEEPING AND SANITATION
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-44">
                                    Simple rules for housekeeping
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-45">
                                    Waste Management
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-46">
                                    PROTECTION OF ENVIRONMENT
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-47">
                                    FIRST AID AND EMERGENCIES
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-48">
                                    First Aid Kit
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-49">
                                    Emergency
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-50">
                                    SAFETY VIOLATIONS AND PENALTIES
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-51">
                                    Safety Improvement Notices:
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-52">
                                    Non Conformance Reports (NCR)
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-53">
                                    Penalties
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-54">
                                    IDENTIFYING HAZARDS, ASSESSING AND CONTROLLING RISKS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-55">
                                    Hazards on Construction Sites
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-56">
                                    Hazard Identification and Assessment
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-57">
                                    Risk Control Hierarchy
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-58">
                                    WORK SAFETY ANALYSIS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-59">
                                    WORK IN CONFINED SPACES
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-60">
                                    Temporary Lighting and Ventilation:
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-61">
                                    MOTOR VEHICLES, TRANSPORTATION &amp; ROAD SAFETY
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-62">
                                    HEIGHT SAFETY
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-63">
                                    Preferred Methods of Preventing Falls
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-64">
                                    LADDERS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-65">
                                    SCAFFOLDING
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-66">
                                    Materials and Supervision
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-67">
                                    Standards or Uprights, Ledgers and Putlogs
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-68">
                                    Additional Requirements for Mobile Scaffolds
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-69">
                                    Suspended Scaffolds
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-70">
                                    CRANES, HOISTS AND LOAD SHIFTING EQUIPMENT
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-71">
                                    Mobile Plant Safety
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-72">
                                    Crane Safety
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-73">
                                    Lifting Gear
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-74">
                                    Safe Operation of Earthmoving Equipment
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-75">
                                    Safe Operation of Forklifts
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-76">
                                    Safety of Hoist ways, Platform and Cage:
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-77">
                                    Operation of Hoists
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-78">
                                    BARRICADES
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-79">
                                    Guarding of floor opening and floor holes
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-80">
                                    Guarding if open-side floors and platform
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-81">
                                    EXCAVATION AND SHORING
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-82">
                                    HANDLING AND STORAGE OF MATERIALS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-83">
                                    Cement
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-84">
                                    Polyethylene pipes
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-85">
                                    Pipes of conducting materials
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-86">
                                    Paints, Varnishes and Thinners
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-87">
                                    Bitumen, Road Tar, Asphalt
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-88">
                                    Bituminous roofing felts
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-89">
                                    Flammable materials
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-90">
                                    ELECTRICAL SAFETY
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-91">
                                    Plugs and Fuses
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-92">
                                    Electrical installations
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-93">
                                    Electrical Works
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-94">
                                    CONCRETE CONSTRUCTION
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-95">
                                    Mixers
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-96">
                                    Trucks
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-97">
                                    Formwork
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-98">
                                    Ramps and gangways
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-99">
                                    Pre-stressed concrete
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-100">
                                    MASONARY WORKS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-101">
                                    HEALTH &amp; HYGIENE STANDARDS
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-102">
                                    Drinking water
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-103">
                                    Washing facilities
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-104">
                                    Latrines and Urinals
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-105">
                                    Provision of shelter during rest
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-106">
                                    Canteens
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:40px;">
                                <a href="#section-107">
                                    Anti-malarial precautions
                                </a>
                            </span>
                            <br />
                            <span style="margin-left:20px;">
                                <a href="#section-108">
                                    TABLE OF CONTENTS
                                </a>
                            </span>
                            <br />
                        </section>
                        <p>
                            ENVIRONMENTAL, HEALTH &amp; SAFETY MANUAL
                        </p>
                        <p>
                            Copyright
                        </p>
                        <p>
                            The copyright of this document is vested with Basilius International and this document in whole or in part may not be reproduced without the written/expressed consent of Basilius International
                        </p>
                        <h1 id="section-1">
                            TABLE OF CONTENTS
                        </h1>
                        <ol type="1">
                            <li id="section-2">
                                <strong>GENERAL PROVISIONS</strong>
                                <ol type="a">
                                    <li id="section-3">
                                        <strong>Introduction</strong>
                                        <p>
                                            It is the objective of Ascentis as Project management consultant that the Contract is completed on time, within budget, and to conforming standards of Health and Safety. This manual has system wide application, and therefore not all of the sections will apply to all Contractors. Each Contractor shall develop his own contract specific Site Safety Plan, which will represent his approach to the management of safety on his work.
                                        </p>
                                        <p>
                                            It is the Contractual obligation of the Contractor at his own cost to fulfill the requirement as mentioned in this manual applicable to the works as defined in Special Conditions of Contract. This manual shall always be read in conjunction with the General &amp; Special conditions of Contract. In case of any contradiction/ambiguity with General conditions of Contract, the interpretation of the clauses of this manual shall prevail but shall be limited to Environment, Health and Safety only. In interpreting the matters related to Environment, Health &amp; Safety, the following order of decreasing importance shall be followed:
                                        </p>
                                        <ol type="i">
                                            <li>Special Conditions of Contract</li>
                                            <li>General Conditions of Contract</li>
                                            <li>EHS Manual</li>
                                            <li>Indian Standard Codes or, if not available, Project Manager’s decision</li>
                                        </ol>
                                    </li>
                                    <li id="section-4">
                                        <strong>Purpose</strong>
                                        <p>
                                            The purpose of this safety manual is to provide all contractors a common set of basic safety requirements applicable to the construction site regardless of its size. The information in this manual deals with hazards that have the potential to produce the highest level of risk. Appropriate safety measures are suggested to control hazards and minimize risk. It is each Contractor’s responsibility to employ a well-qualified and experienced Safety In-Charge responsible for implementing and communicating these procedures.
                                        </p>
                                    </li>
                                    <li id="section-5">
                                        <strong>Scope</strong>
                                        <p>
                                            The scope of this Safety &amp; Health Procedures applies to all contractor and subcontractor employees and to all construction and maintenance activities on the job site. This manual provides information and procedures to assist the Contractor in ensuring that his employees and subcontractors work within a safety-conscious environment. Compliance with this manual does not relieve the Contractor of any statutory duties or responsibilities under the Contract.
                                        </p>
                                    </li>
                                    <li id="section-6">
                                        <strong>Selection of Sub-Contractor</strong>
                                        <p>
                                            The main contractor shall select sub-contractors using the same criteria of practical safety policy. It must be ensured that the terms of contract include adequate provisions for safe working practices and for specified safety and health items. For all works carried out by sub-contractors, the responsibility of ensuring the required HSE lies with the main contractor.
                                        </p>
                                    </li>
                                    <li id="section-7">
                                        <strong>Standards and References</strong>
                                        <p>
                                            The Contractor and all Subcontractors are to comply with the Ascentis rules and procedures, national legislation, and codes, particularly the following standards:
                                        </p>
                                        <ul>
                                            <li>IS: 3696 (Part I) - 1987: Safety code for scaffolds and ladders (Part I: Scaffolds)</li>
                                            <li>IS: 3696 (Part II) - 1991: Safety code for scaffolds and ladders (Part II: Ladders)</li>
                                            <li>IS: 3764 - 1992: Safety code for excavation work</li>
                                            <li>IS: 4014 (Part I) - 1967: Code of Practice for Steel Tubular Scaffolding</li>
                                            <li>IS: 4081 - 1986: Safety code for blasting and related drilling operations</li>
                                            <li>IS: 4082 - 1996: Recommendations on stacking and storage of construction materials at site (first revision)</li>
                                            <li>IS: 4130 - 1976: Safety code for demolition of buildings (first revision)</li>
                                            <li>IS: 4138 - 1977: Safety code for working in compressed air</li>
                                            <li>IS: 4912 - 1978: Safety requirements for floor and wall openings, railings, and toe boards (first revision)</li>
                                            <li>IS: 5121 - 1969: Safety code for piling and other deep foundations</li>
                                            <li>IS: 5916 - 1970: Safety code for constructions involving use of hot bituminous materials</li>
                                            <li>IS: 7205 - 1974: Safety code for erection of structural steel work</li>
                                            <li>IS: 7293 - 1974: Safety code for working with construction machinery</li>
                                            <li>IS: 7969 - 1975: Safety code for handling and storage of building materials</li>
                                            <li>IS: 8989 - 1978: Safety code for erection of concrete framed structures</li>
                                            <li>IS: 10302 - 1982: Unified Nomenclature of Workmen for Civil Engineering</li>
                                            <li>IS: 13415 - 1992: Protective Barriers in and Around Buildings – Code of Safety</li>
                                            <li>IS: 13416 (Part 1–5) - 1992–1994: Recommendations for preventive measures against hazards at workplaces (Parts 1–5)</li>
                                        </ul>
                                    </li>
                                </ol>
                            </li>
                        </ol>


                        <h2 id="section-8">
                            ELEMENTS OF CONSTRUCTION SAFETY
                        </h2>
                        <h3 id="section-9">
                            Contractor’s basic responsibility
                        </h3>
                        <p>
                            The main contractor is responsible for identifying all site safety issues and providing and maintaining the proper systems to ensure the safety of workers, visitors and the public. This includes establishing, prior to commencing work on a site, systems and processes for:
                        </p>
                        <p>
                            Safe access and egress.
                        </p>
                        <p>
                            Site safety needs and amenities.
                        </p>
                        <p>
                            Site conditions and security.
                        </p>
                        <p>
                            Site safety inductions.
                        </p>
                        <p>
                            Provide and maintain plant and equipment that is safe to use.
                        </p>
                        <p>
                            Safety signs and notices.
                        </p>
                        <p>
                            Records, registers and forms.
                        </p>
                        <p>
                            Health and safety consultative arrangements.
                        </p>
                        <p>
                            Lists of contacts on site e.g., Foreman, first aid etc.
                        </p>
                        <p>
                            Emergency procedures.
                        </p>
                        <p>
                            Provide adequate information on hazards, as well as instruction, training and supervision to help you do your work safely.
                        </p>
                        <p>
                            Provide personal protective equipment appropriate for the job.
                        </p>
                        <p>
                            Provide adequate welfare facilities such as amenities and first aid.
                        </p>
                        <p>
                            Provide their Sub-Contractors and their employees with information, instruction, training and supervision to enable them to work in a safe manner.
                        </p>
                        <p>
                            All Contractors and Sub-contractors shall ensure that an adequate level of competent supervision is maintained at the workplace at all times with all supervisory staff having the relevant knowledge, training, and experience to enable them to supervise the work in a proper manner. The main contractor, or a safety in charge appointed by the main contractor, is responsible for making sure that these measures are applied correctly to safeguard all site operations.
                        </p>
                        <h3 id="section-10">
                            Site Rule and Discipline:
                        </h3>
                        <p>
                            All employees and workers are expected to maintain an acceptable standard of behaviour while at work and to treat other co-workers with respect. In particular, unacceptable behaviour that will not be tolerated includes:
                        </p>
                        <p>
                            Taking or being under the influence of alcohol or drugs.
                        </p>
                        <p>
                            Engaging in violence of any kind.
                        </p>
                        <p>
                            Bullying, pranks or horseplay
                        </p>
                        <p>
                            Racial vilification.
                        </p>
                        <p>
                            Any major breaches of the Site Safety Plan, relevant Statutory Provisions and Safety Codes, or any other blatant disregard for the health and safety by any person directly or indirectly associated with the works may result in the ASC exercising their authority in requiring the removal from the Site of required personnel.
                        </p>
                        <h3 id="section-11">
                            Planning and Coordination
                        </h3>
                        <p>
                            The main contractor shall be totally responsible for planning, performance and for compliance with this health and safety code. ASC / Client have the responsibility for reviewing the plan and monitoring a contractor’s performance. Main contractor should fully understand their individual responsibilities during the planning, performance, and completion stages of the work. ASC may notify the contractor where the health and safety requirements are not being met, but it is the responsibility of a contractor to communicate the steps that should be taken to correct the deficiencies to a contractor’s employees.
                        </p>
                        <h3 id="section-12">
                            Monitoring
                        </h3>
                        <p>
                            Arrangements must be made for safety and health monitoring at site on a regular basis. Along with ensuring the safety issues associated with working at heights, excavations, working with energy sources, etc, environmental matters such as hazardous dust, fumes, noise etc also to be considered for monitoring. In all cases, the contractor’s Site-In-charge shall ensure that daily site inspections are carried out by the contractor’s Safety Officer.
                        </p>
                        <h3 id="section-13">
                            Records
                        </h3>
                        <p>
                            The main contractor shall maintain all records which includes but not limited to statutory notifications, examinations and inspection details of vehicles, details of man power, incident reports, safety statistics etc.
                        </p>
                        <h3 id="section-14">
                            Non Compliance with Safety and Health Provisions
                        </h3>
                        <p>
                            All non compliance of EHS provisions on site will lead up to the stoppage of work of particular activity or for an entire area till such time that contractor will carry out all rectification up to the satisfaction of ASC. Any consequences like delay in schedule, cost arising due to this stoppage will be entirely the responsibility of the contractor.
                        </p>
                        <h3 id="section-15">
                            Disciplinary action
                        </h3>
                        <p>
                            Noncompliance of the Safety and Health Provisions will result in disciplinary action as per the procedure below:
                        </p>
                        <p>
                            1st time violation: Written warning
                        </p>
                        <p>
                            2nd time violation: Penalty
                        </p>
                        <p>
                            3rd time violation: Removal from site
                        </p>
                        <p>
                            In the event of the offender bringing himself/herself or others in direct life threatening situation or where he/she creates a large material damage, it will result in immediate removal from site. Repeated violations by a contracting company shall lead to termination of contract and removal of contracting firm from the job site.
                        </p>
                        <p>
                            Any losses incurred by the contracting company, whatsoever, shall be the responsibility of contracting company.
                        </p>
                        <h2 id="section-16">
                            SAFETY ORGANISATION
                        </h2>
                        <p>
                            The main contractor shall appoint designated person to direct and co-ordinate job site safety program. This person should be a full time, technically qualified safety officer and must have received formal training in Health and Safety. In addition, the contracting company shall also appoint required number of safety stewards/supervisors, as per prevailing Laws and regulations. The responsibility of ensuring the safety system of sub contractors also lies with the main contractor.
                        </p>
                        <p>
                            The duties and responsibilities of contractor’s safety manager should be clearly defined at the outset, which will include managing the company health and safety program in order to achieve an accident free environment.
                        </p>
                        <p>
                            Contractor’s safety organization can be structured as follows.
                        </p>
                        <p>
                            Contractors Project Manager: For establishing the safety policy and overall administration of the Safety Program.
                        </p>
                        <p>
                            Safety Manager &amp; safety stewards: For developing, managing and directly enforcing the Safety Program
                        </p>
                        <p>
                            Field Engineers &amp; Foremen: For assisting the Safety Manager in ensuring compliance with the Safety Program.
                        </p>
                        <p>
                            Employees &amp; Labour: For complying with the Safety Program in all respects.
                        </p>
                        <h3 id="section-17">
                            Duties of contractor’s Project Manager.
                        </h3>
                        <p>
                            Establish the safety policy and foster safety awareness within all employees.
                        </p>
                        <p>
                            Assist Safety Manager in the implementation of the Safety Program.
                        </p>
                        <p>
                            Ensure all necessary resources are made available to the Safety Managers.
                        </p>
                        <p>
                            Investigate all safety violations and direct corrective measures.
                        </p>
                        <h3 id="section-18">
                            Duties of contractor’s Safety Manager.
                        </h3>
                        <p>
                            The precise duties of the manager responsible for health and safety will be determined by the contractor/ contracting company concerned and the following should only be taken as a minimum guideline. In general the duties shall include:
                        </p>
                        <p>
                            To manage the company Health and Safety program.
                        </p>
                        <p>
                            To make recommendations on matters concerning health and safety in order
                        </p>
                        <p>
                            to achieve the company’s health and safety objectives.
                        </p>
                        <p>
                            To inspect all or part of the premises daily to ensure the program is being complied with and for potential hazards
                        </p>
                        <p>
                            To prepare Pre task plans and make necessary modifications till they are accepted by Project Manager
                        </p>
                        <p>
                            To arrange adequate materials and publicity for the Health and Safety Program
                        </p>
                        <p>
                            To conduct appropriate job related health and safety training for all new and existing staff whether temporary or permanent. Any job change should be accompanied by relevant retraining.
                        </p>
                        <p>
                            To properly investigate all accidents, damage to property and near miss incidents and make sure that any corrective action is implemented
                        </p>
                        <p>
                            To maintain accident records and make a weekly inspection of first aid records and implement any necessary subsequent action
                        </p>
                        <p>
                            To prepare weekly summaries of injury/damage and inspection reports for senior management
                        </p>
                        <p>
                            To ensure that all fire equipment is regularly inspected and serviced.
                        </p>
                        <p>
                            To ensure the provision of safe tools, equipment and protective clothing where appropriate, and their safe use.
                        </p>
                        <h3 id="section-19">
                            Duties of contractor’s Site Engineers and supervisors
                        </h3>
                        <p>
                            Assist the Safety manager in conducting weekly tool box meetings.
                        </p>
                        <p>
                            Conduct daily pre-work safety briefs, with the labour crew, on accident preventive measures.
                        </p>
                        <p>
                            Enforce compliance, within his area of operation, with all the safety standards prescribed within the Safety Guidelines.
                        </p>
                        <p>
                            Enforce the use of protective equipment.
                        </p>
                        <p>
                            Inspect all equipment and tools for sound condition.
                        </p>
                        <p>
                            Report all accidents and safety violations and enforce corrective action.
                        </p>
                        <p>
                            Continuously inspect work area for unsafe conditions or unsafe practices.
                        </p>
                        <h3 id="section-20">
                            Duties of Contractor’s Employees &amp; Labour
                        </h3>
                        <p>
                            Shall perform their work in a safe manner for prevention of accidents to themselves, fellow workers, the general public and property of all concerned.
                        </p>
                        <p>
                            Shall attend the tool box meetings.
                        </p>
                        <p>
                            Shall alert their foremen of any hazards, unsafe acts and any accident immediately
                        </p>
                        <h2 id="section-21">
                            SAFETY COMMITTEE
                        </h2>
                        <p>
                            A safety committee is one of the best methods of obtaining employee involvement in safety. It provides a formal means of discussing and resolving health and safety issues. The committee should have formal status and its members shall include;
                        </p>
                        <p>
                            Ascentis Project Manager/and Safety representative.
                        </p>
                        <p>
                            Owner’s Safety representative.
                        </p>
                        <p>
                            Contractor’s safety representative.
                        </p>
                        <p>
                            Subcontractor’s safety representatives.
                        </p>
                        <p>
                            Head – Site security.
                        </p>
                        <p>
                            Fire officer.
                        </p>
                        <p>
                            Any other members the management may decide to include.
                        </p>
                        <h3 id="section-22">
                            Objectives of Safety Committees:
                        </h3>
                        <p>
                            The prime objective of a safety committee is to promote co-operation between employers and employees in order to investigate, develop and carry out measures designed to ensure the health and safety at work of the company’s employees, non- employees and other project participants on job site.
                        </p>
                        <h3 id="section-23">
                            Functions of Department Safety Committees:
                        </h3>
                        <p>
                            The key functions of a departmental safety committee shall include;
                        </p>
                        <p>
                            To report on unsafe or unhealthy conditions together with recommendations which can then be made to management.
                        </p>
                        <p>
                            Examining safety audits relating to their area.
                        </p>
                        <p>
                            Considering reports comments and suggestions of safety representatives.
                        </p>
                        <p>
                            Giving assistance in the development of safety rules/ systems of work.
                        </p>
                        <p>
                            Commenting on the effectiveness of the safety content of staff training program.
                        </p>
                        <p>
                            Commenting on the adequacy of health and safety.
                        </p>
                        <p>
                            Communications in the workplace including on-the-job safety meetings.
                        </p>
                        <p>
                            Co-operating with management in carrying out regular safety inspection of departmental areas and reporting the results of these inspections to the main safety committee.
                        </p>
                        <p>
                            The safety committees can only assist Management in taking decisions; they cannot substitute for Management. Management must still take overall responsibility for executive action with a view to ensuring that health and safety arrangements are checked regularly and that the health and safety policy as a whole is being implemented properly.
                        </p>
                        <p>
                            The safety committee shall conduct weekly/fortnightly meetings and the minutes shall be circulated to the management.
                        </p>
                        <h2 id="section-24">
                            SAFETY INDUCTION AND TRAINING
                        </h2>
                        <p>
                            The Contractor shall ensure that all the employees are suitably trained in the proper work procedures and health and safety regulations pertaining to their duties. New personnel assigned to the site will receive orientation training.
                        </p>
                        <h3 id="section-25">
                            Objectives of Safety Induction and Training
                        </h3>
                        <p>
                            Contractor must communicate with workers so that they understand that health and safety is considered an important part of the work process, and they are aware of how to do their jobs safely. Well trained and competent workers not only perform their jobs safely, but are more productive. This includes training in the use of plant, equipment and substances, and in work practices including safe work method statements and job safety analyses.
                        </p>
                        <h3 id="section-26">
                            Site Specific Induction
                        </h3>
                        <p>
                            It is an introduction to the site to inform workers about site rules and safety procedures, making sure they understand them before commencing work, rather than relying on them to “pick it up” as they go along. The initial site-specific induction should be followed by on-going safety and training to help employees work safely and efficiently.
                        </p>
                        <p>
                            Site specific induction shall cover the following.
                        </p>
                        <p>
                            Site safety rules, policies.
                        </p>
                        <p>
                            Site amenities and welfare.
                        </p>
                        <p>
                            Emergency procedures, site specific hazards and control measures.
                        </p>
                        <p>
                            How safety issues and disputes are resolved.
                        </p>
                        <p>
                            How to report hazards or unsafe work practices, accidents, incidents and dangerous occurrence.
                        </p>
                        <p>
                            First aid procedures and steps to be followed if anyone is injured.
                        </p>
                        <p>
                            Records of the training should be maintained by contractor and made available to ASC.
                        </p>
                        <p>
                            ASC will periodically review contractor’s training records to verify the proper training is being conducted. Contractor should periodically review the training schedules and materials to verify they are current.
                        </p>
                        <h2 id="section-27">
                            COMMUNICATION &amp; MEETINGS
                        </h2>
                        <p>
                            A site communication chart will be produced by the Contractor and updated regularly indicating specific areas of responsibility with staff names and mobile numbers. This chart shall list all subcontracts’ names and numbers also.
                        </p>
                        <p>
                            The Contractor shall install bi-lingual safety signs around the site which will include illustrated signs instructing its workforce to wear safety helmets, proper footwear, eye protection, and other safety equipment. Signage will also be provided to identify entrances, access routes for heavy equipment, safety hazards, first aid locations and emergency plan and emergency contact information.
                        </p>
                        <h3 id="section-28">
                            Bi Weekly management Safety meeting.
                        </h3>
                        <p>
                            These meetings are to be held with all contractors with ASC safety engineer/Project manager to review any safety violation, accidents, near misses, safety audits and any other safety specific topics.
                        </p>
                        <h3 id="section-29">
                            Weekly Tool box meetings
                        </h3>
                        <p>
                            A weekly ' Tool box ' safety meeting on the first day of the week shall be held by the concerned discipline supervisor / foreman with the work-force under their control.
                        </p>
                        <p>
                            Proposed topics under tool box meeting are:
                        </p>
                        <p>
                            Use of Personal Protective Equipment (PPE);
                        </p>
                        <p>
                            Safety in use of Hand Tools;
                        </p>
                        <p>
                            Safety in use of Portable Electrical Tools;
                        </p>
                        <p>
                            Safety while welding /gas cutting operation;
                        </p>
                        <p>
                            Safety in Scaffold Erecting &amp; Dismantling;
                        </p>
                        <p>
                            Safety while Working at Height;
                        </p>
                        <p>
                            House keeping &amp; Fire Prevention;
                        </p>
                        <p>
                            Safety while Material Handling;
                        </p>
                        <p>
                            Safety while Grinding Operation;
                        </p>
                        <p>
                            Safety in working in Confined spaces
                        </p>
                        <p>
                            Emergency Response procedure
                        </p>
                        <p>
                            In addition to this meeting an extra ' Tool box ' talk shall be given by the concern supervisor, prior to start of every new activity..
                        </p>
                        <h3 id="section-30">
                            Emergency Safety Meeting
                        </h3>
                        <p>
                            Emergency safety meetings will be called by the Contractor in response to a stop work notice issuance or a major accident. Attendance is mandatory for ASC, Contractor Project Manager, Contractor safety personals and all levels of subcontractors involved. The purpose of the meeting will be to identify root causes and formulate an action plan for prevention. This meeting must be successfully completed before work may begin. The place, time for the meeting will be arranged by ASC.
                        </p>
                        <h2 id="section-31">
                            SAFETY INSPECTIONS AND REPORTS
                        </h2>
                        <h3 id="section-32">
                            Daily Safety inspection
                        </h3>
                        <p>
                            During the construction phase, Safety In-Charge of the Contractor along with the discipline Supervisor shall carryout inspection of work site daily to ascertain whether the implementation of various procedures have been carried out as per plan or not. The deficiencies observed during the inspection shall be rectified by the concerned discipline supervisor / foreman.
                        </p>
                        <p>
                            It is the responsibility of all supervisors to regularly observe project sites, work areas, tools, and equipment daily, and take all appropriate actions necessary to eliminate or control any hazards that are identified
                        </p>
                        <p>
                            The Project Manager of Contractor and of Ascentis shall make scheduled and surprise inspections. The results of his inspection will be discussed with the project management and supervisory staff immediately following the inspection. Supervisors will take immediate action to eliminate, correct, or control the hazard, or ensure that project management has taken such action
                        </p>
                        <h3 id="section-33">
                            Weekly Safety Walk around
                        </h3>
                        <p>
                            A weekly safety walk around will be conducted by ASC and Contractor’s Safety Manager over the site to inspect the safety standard maintaining by the contractor and sub contractor’s including the standard of housekeeping. Attendance by the Safety Representatives, field engineers, trade superintendents and foremen for each site will be mandatory. Any safety violations or accidents will be reviewed and
                        </p>
                        <p>
                            corrective action initiated. Potential safety hazards will be analyzed for enforcing preventive measures. Corrective actions and instruction on the Audit report to be implemented within the time frame by the contractor.
                        </p>
                        <h3 id="section-34">
                            Contractor’s Monthly Safety Report
                        </h3>
                        <p>
                            The Contractor shall submit a monthly safety report to ASC within seven days of the end of each month for review and record. The report will include a summary of the safety related activities during the month and detail the following information:
                        </p>
                        <p>
                            Total Number of Site Employees
                        </p>
                        <p>
                            Total Number of safety personnel (in the chart form)
                        </p>
                        <p>
                            Man-hours Expended
                        </p>
                        <p>
                            Lost Time Accidents &amp; Reports
                        </p>
                        <p>
                            Monthly Accident/Near Miss/Incident Statistical Analysis
                        </p>
                        <p>
                            Medical Treatment Cases &amp; Monitoring/First Aid Cases
                        </p>
                        <p>
                            Equipment Inspection Reports
                        </p>
                        <p>
                            Scaffold Monthly Inspection Reports
                        </p>
                        <p>
                            Tower Crane Monthly Inspection Reports
                        </p>
                        <p>
                            Hazardous Materials Report
                        </p>
                        <p>
                            Record of Workers Attending Safety Induction Training
                        </p>
                        <p>
                            Training Activities &amp; Reports
                        </p>
                        <p>
                            Safety Audit/Inspection Reports
                        </p>
                        <p>
                            Minutes of Toolbox Meetings
                        </p>
                        <p>
                            Record of Disciplinary Actions Related to SHE Program
                        </p>
                        <p>
                            Property Damage Report
                        </p>
                        <p>
                            Amendments/Revisions to the SHE Guidelines.
                        </p>
                        <h2 id="section-35">
                            WORK PERMITS
                        </h2>
                        <p>
                            The Contractor shall obtain a permit-to-work from ASC, which is a formal written system used to control certain types of work that are potentially hazardous. A permit-to-work is a document, which specifies the work to be done, and the precautions to be taken. Permits-to-work form an essential part of safe systems of work for many construction activities. They allow work to start only after safe procedures have been defined and they provide a clear record that all foreseeable hazards have been considered.
                        </p>
                        <h2 id="section-36">
                            PERSONNEL PROTECTION
                        </h2>
                        <p>
                            The Contractor and Sub-Contractor are responsible for the provision of appropriate personal protective equipment (PPE) for themselves and their employees. PPE is to be appropriate for the particular hazard to which the person is exposed and shall comply with current statutory or Indian/any other applicable Standards
                        </p>
                        <p>
                            specifications. The Contractor is responsible for ensuring that the PPE provided to their employees is used when required.
                        </p>
                        <p>
                            Safety shoes, safety helmets and fluorescent jacket to be worn by all employees and workers at all time in work site.
                        </p>
                        <p>
                            Safety glasses or goggles are compulsory in designated eye protection areas and when using power or machine tools and pressure equipment. Face shields should be worn when handling acids and chemicals. Suitable welding goggles must be worn for gas welding and cutting. Welding helmets to be worn for electric arc welding. Use welding screens to protect the eyes of other persons from welding flashes.
                        </p>
                        <p>
                            Ear-plugs/ear-muffs must be worn in designated areas and wherever high noise levels are present e.g. Jackhammers, grinders, explosive-powered tools, pile driving.
                        </p>
                        <p>
                            Suitable face masks shall be supplied for use by workers during painting work.
                        </p>
                        <p>
                            Other - Specific jobs may cause the need for other personal protective equipment. When this occurs, the employee is expected to utilize this safety equipment. It is the Contractor's responsibility to see that equipment in use is appropriate and in good condition.
                        </p>
                        <h2 id="section-37">
                            ACCIDENT PREVENTION, REPORTING AND INVESTIGATION
                        </h2>
                        <h3 id="section-38">
                            Incidents &amp; accidents
                        </h3>
                        <p>
                            It is essential to have an effective management system for recording accidents. ASC and Client shall be notified by the quickest possible means, for example by telephone of the following classifications of accidents and incidents and by subsequent written notification within twenty four hours on the Contractors Accident and Incident report form.
                        </p>
                        <p>
                            Fatal Accident
                        </p>
                        <p>
                            Major Injury Accident
                        </p>
                        <p>
                            Dangerous Occurrence
                        </p>
                        <p>
                            Any Incident involving a member of the public
                        </p>
                        <p>
                            The Contractor shall immediately follow-up and report on the corrective action taken to rectify the potential in the specified format given in Appendix.
                        </p>
                        <p>
                            Incident / Accident Reporting: Incidents / Accident should be reported on an incident report form given in Appendix. Typical information on an incident reporting form may include the:
                        </p>
                        <p>
                            Accident/incident description.
                        </p>
                        <p>
                            Identification and implementation of the corrective actions to prevent a recurrence.
                        </p>
                        <p>
                            Immediate and root causes of the accident/incident.
                        </p>
                        <p>
                            Management and/or program deficiencies.
                        </p>
                        <p>
                            Names of the affected employees or the witnesses.
                        </p>
                        <p>
                            Person responsible for assuring the implementation of the corrective actions.
                        </p>
                        <p>
                            Timetables for the corrective actions.
                        </p>
                        <p>
                            The Contractor shall report immediately, orally and in writing, all fatal accidents, and other occurrences requiring reporting, to the police, at the police station in whose jurisdiction the accident occurred.
                        </p>
                        <h3 id="section-39">
                            Accident Investigation
                        </h3>
                        <p>
                            Accidents which result in death, serious injury or serious damage and Near misses must be investigated by the Contractor immediately to find out the cause of the accident so that measures can be formulated to prevent any recurrence. Investigations should be conducted in an open and positive atmosphere that encourages the witnesses to talk freely.
                        </p>
                        <p>
                            The primary objective is to ascertain the facts with a view to prevent future and possibly more serious occurrences.
                        </p>
                        <h3 id="section-40">
                            Near Miss
                        </h3>
                        <p>
                            Any near miss occurrence that does not cause an injury or property damage must be reported. Listed below are examples of high potential incidences that would qualify as a near miss.
                        </p>
                        <p>
                            An Explosion or fire.
                        </p>
                        <p>
                            Collapse or overturning of lifting equipment.
                        </p>
                        <p>
                            Environmental damage such as fuel or other hazardous material spill.
                        </p>
                        <p>
                            Collapse of staging or platform.
                        </p>
                        <p>
                            Material falling from upper floor and people working on ground have a narrow miss.
                        </p>
                        <h3 id="section-41">
                            Recommended actions in investigation
                        </h3>
                        <p>
                            It is important after any Accident or Dangerous Occurrence that information relating to the incident is gathered in an organised way. The following steps are recommended;
                        </p>
                        <p>
                            Take photographs and make sketches
                        </p>
                        <p>
                            Examine involved equipment, workpiece or material and the environmental conditions
                        </p>
                        <p>
                            Interview the injured, eye-witnesses and other involved parties
                        </p>
                        <p>
                            Consult expert opinion where necessary
                        </p>
                        <p>
                            Identify the specific Contractor or Sub-contractor involved.
                        </p>
                        <p>
                            Having gathered information, it is then necessary to make an Analysis of Incident
                        </p>
                        <p>
                            Establish the chain of events leading to the accident or incident
                        </p>
                        <p>
                            Find out at what stage the accident took place
                        </p>
                        <p>
                            Consider all possible causes and the interaction of different factors that led up to the accident, and identify the most probable cause
                        </p>
                        <p>
                            Note: The cause of an accident should never be classified as carelessness. The specific act or omission that caused the accident must be identified.
                        </p>
                        <p>
                            The next stage is to proceed with the Follow-up Action
                        </p>
                        <p>
                            Report on the findings and conclusions
                        </p>
                        <p>
                            Formulate preventive measures to avoid recurrence
                        </p>
                        <p>
                            Publicize the findings and the remedial actions taken
                        </p>
                        <h2 id="section-42">
                            ACCIDENT STATISTICS
                        </h2>
                        <p>
                            Accident data, if properly collected and analyzed, indicates trends, and can show where and how problems arise. Comprehensive accident information enables accident prevention efforts to be targeted at problem areas.
                        </p>
                        <p>
                            Statistical formulae:
                        </p>
                        <p>
                            Reportable Accidents: This is the total number of accidents/incidents including all reportable and serious accidents
                        </p>
                        <p>
                            Lost time Accidents: This is the number of accidents where an employee is absent from work for more than 24 hours (1 day).
                        </p>
                        <p>
                            Percentage man hours lost: This is the total number of hours lost expressed as a percentage of total man hours worked.
                        </p>
                        <p>
                            Total Man hours lost X 1000,000 / Total man hours worked
                        </p>
                        <p>
                            The lost time accidents, reportable accidents and percentage man hours lost should be adjusted monthly as part of the Project Manager’s review. The figures given in each category should be for the month under review, the year to date and the previous year to date.
                        </p>
                        <p>
                            Accident Frequency rate: This is the total number of lost time accidents per million man hours worked by permanent and temporary employees
                        </p>
                        <p>
                            Total number of lost time accidents X 1000,000 / Total number of man hours worked
                        </p>
                        <p>
                            Accident incident rate: This is the total number of lost time accidents per 100,000 employees.
                        </p>
                        <p>
                            Total number of lost time accident per 1000,000 employees / Total number of employees
                        </p>
                        <p>
                            For this calculation the total number of employees should be averaged out over the year. Part time employees should be included in proportion to the time worked.
                        </p>
                        <p>
                            The accident frequency rate and accident incidence rate should be calculated annually and reported in the year end results. (This shall also be part of contractor’s monthly safety report)
                        </p>
                        <p>
                            In addition to the statistics referred to above, all data pertaining to incidents must also be kept at site.
                        </p>
                        <h2 id="section-43">
                            HOUSEKEEPING AND SANITATION
                        </h2>
                        <p>
                            A clean project site promotes efficiency, quality control, and most importantly reduces safety, health and environmental risks. Adequate trash collection and removal procedures will be established with particular attention to combustible materials. Materials and equipment will be stored and staged on the site in an organized manner.
                        </p>
                        <p>
                            Daily and weekly safety inspections will focus specifically on maintaining a high level of housekeeping on the project site. ‘No smoking’ signs will be posted throughout the project site. The Contractor will stress the importance of housekeeping as a concurrent activity with construction task
                        </p>
                        <p>
                            Good housekeeping is an important element of accident prevention. It should be planned at the beginning of the job and carefully supervised until the final clean-up while handing over the site to the client.
                        </p>
                        <p>
                            It is recommended to have a regular clean up in all our job sites to ensure cleanliness, tidiness, and safe environment. However, housekeeping should be the concern of all supervisors and engineers in their area of working and not left for the clean-up crew. In any case, housekeeping should be a part of daily routine with clean up being a continuous procedure in order to maintain the site and surroundings in a neat and orderly manner, free of accumulating debris, haphazard stacking of materials, unhygienic and unsafe environment.
                        </p>
                        <h3 id="section-44">
                            Simple rules for housekeeping
                        </h3>
                        <p>
                            Storage areas: All materials should be maintained in neat stockpiles with well laid aisles and walkways for ease of access. There shall not be any projections in the walkways.
                        </p>
                        <p>
                            Work areas: Loose materials, scrap, tools, etc. shall not be allowed to be lying in the working areas especially in the vicinity of ladders, ramps stairs, etc. This is more important at heights where the loose materials are liable to fall down. Spills of oil and grease should be removed immediately.
                        </p>
                        <p>
                            An effective means of preventing loose pieces lying dangerously at heights is the provision of suitable receptacles for waste and scrap pieces. Equipment and other materials should not be kept/ left in hazardous condition. Special attention is to be paid to potential fire hazards, which is to be suitably handled / discarded. Nothing shall be done or omitted to be done to render unsafe or obstruct access for emergency apparatus, such as fire fighting equipment.
                        </p>
                        <p>
                            Protruding nails: Protruding nails in wooden pieces is a chronic problem in civil sites, it is worthwhile to have one or two helpers continuously for retrieving protruding nails.
                        </p>
                        <p>
                            Scrap yard: Wooden scrap should be well away from any gas cutting or welding operations and “No smoking” shall be strictly ensured there. All other combustible scrap like cotton waste, wooden boxes, empty paint tins shall be disposed off safely then and there.
                        </p>
                        <p>
                            Lighting: Adequate lighting should be provided in and around all work areas, passage ways, stairs, ladders &amp; other areas used by personnel.
                        </p>
                        <p>
                            Openings in floor: All openings in floors where workmen are liable to work or even pass through shall be either closed or barricaded whose minimum
                        </p>
                        <p>
                            height should be 1mtr. If they are closed, a visible warning sign shall be kept to indicate the opening below the cover.
                        </p>
                        <p>
                            Approach road: The approach road from and to the work site shall never be blocked by parking vehicles or stacking materials, etc. thus blocking the movement in case of emergencies.
                        </p>
                        <p>
                            The Contractor shall provide sufficient canteen and sanitary facilities including toilets, washing areas, and refuse containers to meet the requirements of project. These facilities shall be maintained in a hygienic and well organized manner, and inspected daily by contractor management staff. The waste management plan shall provide details concerning the handling of human waste and construction debris. These facilities will be detailed in the submissions associated with the site logistics plan and shall meet the requirements of Indian regulations.
                        </p>
                        <p>
                            Daily and weekly safety inspections will focus specifically on maintaining a high level of housekeeping on the project site. ‘No smoking’ signs will be posted throughout the project site. The Contractor will stress the importance of housekeeping as a concurrent activity with construction task
                        </p>
                        <h3 id="section-45">
                            Waste Management
                        </h3>
                        <p>
                            Specific disposal requirement will be identified / provided to assist site management. Sub-contractors and others will be clearly notified the goals to assist the client in maintaining the site environment safe.
                        </p>
                        <p>
                            The waste management plan will observe three categories of waste:
                        </p>
                        <p>
                            Domestic and office wastes – generally non-hazardous can be disposed of in a simple disposable facility within waste containers as suitable.
                        </p>
                        <p>
                            Industrial (Non-hazardous) waste can also be disposed of in a simple disposable facility.
                        </p>
                        <p>
                            Hazardous wastes, special or chemical, require disposal in accordance with the environmental protection act to prevent any hazard to human health or to the environment
                        </p>
                        <p>
                            Garbage chute shall be erected at suitable location so that the waste from the upper floors can be collected and disposed off through the garbage chute from where it can be carted away.
                        </p>
                        <h2 id="section-46">
                            PROTECTION OF ENVIRONMENT
                        </h2>
                        <p>
                            The Contractor understands that the Site is free from pollutants at the time of access to the Site and commencement of the Works. The Contractor shall comply with all Applicable Laws in relation to environment and shall ensure that the Site is and remains free from pollutants at the competition of the Project. The Contractor shall ensure inter alia, that neither the soil nor the ground water is polluted or contaminated by fuels or lubricants emitted by machinery operated on the Site or by other dangerous or poisonous substances which are or are deemed to be hazardous to the environment. Notwithstanding the above, the Contractor shall comply with all the directions and decisions of the Project Manager in this regard and all applicable environmental legislations in relation to the same including obtaining statutory consents and approvals as may be required.
                        </p>
                        <h2 id="section-47">
                            FIRST AID AND EMERGENCIES
                        </h2>
                        <p>
                            Contractor shall provide required number of qualified person/s as First aiders for rendering necessary first aid to people deployed at site if they are injured or become ill at work along with sufficient supply of first aid kits in a well maintained first-aid room. First Aid rooms should be clearly identified and of sufficient size to allow access for a stretcher, wheelchair.
                        </p>
                        <p>
                            In the absence of dispensaries, clinics, or hospitals in proximity to the work site, appropriate arrangement for the transportation of the injured personnel to a physician or hospital must be provided for.
                        </p>
                        <p>
                            The names of first aid officers, first aid procedures and emergency contact phone numbers should be part of the induction process and displayed in prominent locations visible to all workers.
                        </p>
                        <h3 id="section-48">
                            First Aid Kit
                        </h3>
                        <p>
                            Regardless of the number of people there must be at least one first-aid box on site and provision should be made for every person to have reasonably rapid access to first aid. Each box should be placed in a clearly identified and readily accessible location, and contain a sufficient quantity of suitable first-aid materials. Boxes and kits should be checked frequently to ensure they are fully stocked and all items are in a usable condition. Sufficient quantities of each item should always be available in every first aid box or cabinet. Follow the table below as a guide line for First Aid kit.
                        </p>
                        <h3 id="section-49">
                            Emergency
                        </h3>
                        <p>
                            An emergency is an actual or imminent occurrence (such as an accident, fire, bomb threat, gas and chemical explosion, flood or storm, collapse of a building or structure) which:
                        </p>
                        <p>
                            Endangers, or threatens to endanger the health or safety of persons, or
                        </p>
                        <p>
                            Destroys or damages, or threatens to destroy or damage property
                        </p>
                        <p>
                            Contractor shall prepare and Emergency response plan by identifying all potential disasters and it is to be displayed prominently to instruct all workers and visitors. Emergency plan must contain the following details.
                        </p>
                        <p>
                            The alarm signal for evacuation
                        </p>
                        <p>
                            The correct way to exit the building.
                        </p>
                        <p>
                            What you should do and what you should not do in an emergency.
                        </p>
                        <p>
                            The safe assembly point.
                        </p>
                        <p>
                            The site personnel in charge of emergencies
                        </p>
                        <p>
                            Contact for emergency and rescue services
                        </p>
                        <p>
                            A register of who is on site should be kept so that in the case of an emergency everyone can be accounted for.
                        </p>
                        <p>
                            Undertake a head count to determine if all workers have been evacuated.
                        </p>
                        <p>
                            Emergency Contact Numbers:
                        </p>
                        <p>
                            In addition to the above the main contractor shall display Emergency contact numbers in prominent location on the site.
                        </p>
                        <p>
                            Project name Project No.
                        </p>
                        <p>
                            The following are the business telephone numbers where project key personnel can be reached at all times. In addition, the emergency telephone numbers of other vital agencies are listed:
                        </p>
                        <p>
                            BUSINESS RESIDENCE
                        </p>
                        <p>
                            Project Manager
                        </p>
                        <p>
                            Owner Project Manager Contractor Safety Officer PMC Safety Officer
                        </p>
                        <p>
                            Fire officer Security officer
                        </p>
                        <p>
                            OTHER EMERGENCY TELEPHONE NUMBERS
                        </p>
                        <p>
                            Fire :
                        </p>
                        <p>
                            Ambulance :
                        </p>
                        <p>
                            Doctor :
                        </p>
                        <p>
                            Hospital :
                        </p>
                        <p>
                            Police :
                        </p>
                        <p>
                            Gas Company :
                        </p>
                        <p>
                            Electric Company :
                        </p>
                        <p>
                            Water Company :
                        </p>
                        <p>
                            Telephone Company:
                        </p>
                        <p>
                            Insurance Carrier :
                        </p>
                        <p>
                            Other :
                        </p>
                        <h2 id="section-50">
                            SAFETY VIOLATIONS AND PENALTIES
                        </h2>
                        <p>
                            Safety instructions and Non Conformance Reports will be utilized to formally notify the contractor of safety issues in the specified formats.
                        </p>
                        <h3 id="section-51">
                            Safety Improvement Notices:
                        </h3>
                        <p>
                            It will be issued to the contractor immediately at site for any safety issues. This notification requires an immediate written response regarding corrective action taken as well as a specific time line for corrective action. These notices are primarily for non compliance to safety problems for which time may be allotted for correction.
                        </p>
                        <h3 id="section-52">
                            Non Conformance Reports (NCR)
                        </h3>
                        <p>
                            NCRs will be issued for a severe safety problem or failure to comply with previous Safety instructions. Immediate action is required and contractor is instructed to cease the work if required depending on the severity in all related areas until the correction is made and NCR is closed.
                        </p>
                        <h3 id="section-53">
                            Penalties
                        </h3>
                        <p>
                            Contractor shall be charged with penalties which are divided into 4 categories as per the details given the appendix.
                        </p>
                        <p>
                            3 star penalty of Rs: 3000/-
                        </p>
                        <p>
                            2 star penalty of Rs: 2000/-
                        </p>
                        <p>
                            1 star penalty of Rs: 1000/-
                        </p>
                        <p>
                            Normal penalty of Rs: 500/-
                        </p>
                        <p>
                            Ascentis shall issue a debit note containing the penalty amount and violation reference, in the name of the Contractor signed by the Ascentis Site Safety In- charge and the Project Manager. Ascentis Site Safety In-charge will then forward the Contractor’s received copy to Ascentis’s Commercial department for deduction of the penalty from the R.A Bill or from any due payment of the Contractor. This deduction shall be reflected in Contractor’s Payment Certificate.
                        </p>
                        <p>
                            3 Star Penalty Details:
                        </p>
                        <p>
                            Working at heights without safety belt
                        </p>
                        <p>
                            Falling objects on head without helmet
                        </p>
                        <p>
                            Electrical hazards
                        </p>
                        <p>
                            Mobile Equipment without proper documents etc
                        </p>
                        <p>
                            Working in shaft, periphery walls and deep opening of floors without proper platform, scaffold, safety belt, safety net, Work permit, unsafe safety belt, unsafe scaffold items, Life line rope, Hand rails, Toe boards, Damaged jallies, non-provision of safety nets
                        </p>
                        <p>
                            2 Star Penalty Details:
                        </p>
                        <p>
                            Damage of materials and property (small value items)
                        </p>
                        <p>
                            Hot work without proper documents &amp; unsafe work
                        </p>
                        <p>
                            1 Star Penalty Details:
                        </p>
                        <p>
                            Not closing chambers, earth pits and any other openings
                        </p>
                        <p>
                            Poor housekeeping, debris not removed, scrap &amp; excess materials
                        </p>
                        <p>
                            Theft of small value items Normal Penalty Details:
                        </p>
                        <p>
                            Working without PPE such as shoes, hand gloves, safety goggles, Ear muff,
                        </p>
                        <p>
                            Ear plug, Nose mask, Climbing ladder, Stand, unsafe PPE’s
                        </p>
                        <p>
                            Damage of barricading
                        </p>
                        <p>
                            Damage of machines
                        </p>
                        <p>
                            Quarreling in sites
                        </p>
                        <p>
                            Damage of pipelines
                        </p>
                        <p>
                            Working without Flash back arrester hose conditions
                        </p>
                        <p>
                            Non-provision of Fire watcher
                        </p>
                        <p>
                            Improper cutting torch and holder
                        </p>
                        <p>
                            Not using proper welding shield &amp; gas cutting goggles
                        </p>
                        <p>
                            Improper Illumination
                        </p>
                        <p>
                            Improper light fittings
                        </p>
                        <p>
                            Spoiling the floor like urinating in site, spitting on floors &amp; walls, taking food in buildings &amp; smoking in site
                        </p>
                        <p>
                            Improper welding cable conditions, holder, lugs conditions
                        </p>
                        <p>
                            Unsafe grinder or any rotating machines without guards etc.
                        </p>
                        <p>
                            Gas cylinders kept unsafe, non-provision of fire extinguishers at site.
                        </p>
                        <h2 id="section-54">
                            IDENTIFYING HAZARDS, ASSESSING AND CONTROLLING RISKS
                        </h2>
                        <h3 id="section-55">
                            Hazards on Construction Sites
                        </h3>
                        <p>
                            The majority of injuries, which occur on construction sites, are back injuries, sprains and strains due to manual handling tasks such as lifting, pushing, pulling and stretching. Statistics show that the most frequent ways construction workers are killed are through:
                        </p>
                        <p>
                            Falling from heights
                        </p>
                        <p>
                            Electrocution
                        </p>
                        <p>
                            Being hit or crushed by powered mobile plant Other hazards common in the construction industry are:
                        </p>
                        <p>
                            Falling objects
                        </p>
                        <p>
                            Structural collapse and collapse of trenches
                        </p>
                        <p>
                            Compressed air
                        </p>
                        <p>
                            Dangerous substances (paints, chemicals etc.)
                        </p>
                        <p>
                            Confined spaces
                        </p>
                        <p>
                            Welding fumes, gases and arcs
                        </p>
                        <p>
                            Explosive powered tools and lasers
                        </p>
                        <p>
                            Hazardous dusts, e.g. silica, asbestos, medium density fibre board (MDF), synthetic mineral fibres (SMF)
                        </p>
                        <h3 id="section-56">
                            Hazard Identification and Assessment
                        </h3>
                        <p>
                            Before commencing tasks, all foreseeable hazards (for example, falling off a roof) and actual risks (e.g. death, serious injury) should be identified and appropriate safety measures to be put in place (e.g. installing guard railing).
                        </p>
                        <p>
                            This risk management process is made up of the following steps:
                        </p>
                        <p>
                            Identify the hazards.
                        </p>
                        <p>
                            Assess the risks arising from the hazard.
                        </p>
                        <p>
                            Implement appropriate control measures to eliminate or reduce the risks.
                        </p>
                        <p>
                            Monitor and review the control measures to ensure continual safety.
                        </p>
                        <p>
                            A hazard identification, risk assessment and control process should be carried out by the contractor and should be documented.
                        </p>
                        <p>
                            Subsequent to the kick-off meeting, within the specified time period, the contractor will also provide the list of tasks against which Work safety analysis shall be submitted along with the expected time, when it would be submitted.
                        </p>
                        <p>
                            Control measures are selected by working through steps 1 to 6 of the risk control hierarchy below, starting at elimination as the most desirable option and personal protective equipment as the last resort.
                        </p>
                        <h3 id="section-57">
                            Risk Control Hierarchy
                        </h3>
                        <p>
                            Elimination of risks by eliminating the hazard, plant, tool or substance, if practicable. If this is not practicable, risk shall be reduced by one or combination of:
                        </p>
                        <p>
                            Substitution by a less hazardous activity, plant, tool or substance
                        </p>
                        <p>
                            Isolation of the hazard to prevent or reduce exposure to it.
                        </p>
                        <p>
                            Engineering controls – for example, exhaust ventilation for dusts, fumes or vapours
                        </p>
                        <p>
                            Administrative controls - providing training, adopting safe work procedures or instructions to minimise exposure to the hazard
                        </p>
                        <p>
                            Personal protective equipment to be used as a last resort and only when risk has been reduced as far as practicable by one or a combination of the above
                        </p>
                        <h2 id="section-58">
                            WORK SAFETY ANALYSIS
                        </h2>
                        <p>
                            Contractors are often required to submit Work Safety Analysis before carrying out their activities on construction sites.
                        </p>
                        <p>
                            A Work Safety Analysis sets out the work method in a logical sequence. The hazards associated with each process are identified, and the measures for controlling these hazards specified.
                        </p>
                        <p>
                            Any job or task, no matter how simple or complex, can be broken down into a series of basic steps that will permit a systematic analysis of each part of the job for hazards and potential accidents. The description of the process should not be so broad that it leaves out activities with the potential to cause accidents and prevents proper identification of the hazards; nor is it necessary to provide too fine a detail of the tasks.
                        </p>
                        <p>
                            The aims of a Work Safety Analysis are to:
                        </p>
                        <p>
                            Describe the job or task to be undertaken.
                        </p>
                        <p>
                            Identify the resources, manpower and skills associated with the task.
                        </p>
                        <p>
                            Assess and select hazard controls as appropriate.
                        </p>
                        <p>
                            Systematically plan the job so it can be completed efficiently and effectively. When developing Work Safety Analysis, the following should be considered:
                        </p>
                        <p>
                            Its development and documentation prior to the commencement of the job.
                        </p>
                        <p>
                            Incorporation of information obtained from employees.
                        </p>
                        <p>
                            Risk assessment results should be incorporated.
                        </p>
                        <p>
                            Job procedure should be explained step-by-step in a logical sequence.
                        </p>
                        <p>
                            It should be read and understood by the employees, before commencement of work.
                        </p>
                        <p>
                            It should be signed by the employees, once it has been read and understood.
                        </p>
                        <p>
                            Included as part of employee induction training.
                        </p>
                        <p>
                            Become part of the overall site safety plan written in pre developed chart or format.
                        </p>
                        <h2 id="section-59">
                            WORK IN CONFINED SPACES
                        </h2>
                        <p>
                            A confined space is a place with a restricted means for entry or exit, where harmful substances, lack of oxygen and other hazards may increase the risk of injury to those entering the space. In the construction industry confined spaces may be air conditioning ducts, crawl spaces, pits, trenches, pipes, sewers or box beams.
                        </p>
                        <p>
                            All employees who are required to work in a confined space should receive full information, instruction and training in relation to hazards and risks and be made aware of the relevant risk assessment for the confined space work.
                        </p>
                        <p>
                            The risk assessment should include the following control measures.
                        </p>
                        <p>
                            An entry permit signed on and off by the immediate supervisor describing:
                        </p>
                        <p>
                            The confined space that the permit applies to
                        </p>
                        <p>
                            The measures for control of risks
                        </p>
                        <p>
                            The names of the employees approved to enter the space
                        </p>
                        <p>
                            The name of the stand-by person assigned to the confined space
                        </p>
                        <p>
                            The period of time for which the permit is valid Stand-by arrangements for:
                        </p>
                        <p>
                            Continuous communication between the persons in the confined space and a responsible person on the outside
                        </p>
                        <p>
                            Emergency procedures that can be initiated from outside the space
                        </p>
                        <p>
                            The procedure to know when employees have entered or exited the confined space
                        </p>
                        <p>
                            Emergency procedures for rescue and first aid Always use an Air Quality Monitor before entering a confined space.
                        </p>
                        <h3 id="section-60">
                            Temporary Lighting and Ventilation:
                        </h3>
                        <p>
                            The Contractor shall at its own cost, make necessary arrangements in respect of the provision of adequate lighting and ventilation (natural as well as artificial) at all places where its workmen are engaged for carrying out the Works in a proper, safe and satisfactory manner. The Contractor shall also provide general lighting in common areas such as entrances, staircases, etc with minimum LUX level requirements besides illuminating the Works places.
                        </p>
                        <h2 id="section-61">
                            MOTOR VEHICLES, TRANSPORTATION &amp; ROAD SAFETY
                        </h2>
                        <p>
                            A site traffic plan must be made to control all traffic on site and movement of materials, parking etc.
                        </p>
                        <p>
                            Fitness of vehicle: All vehicles that are used on construction site must be in fit condition and should carry proper fitness certificate.
                        </p>
                        <p>
                            Driving License: All drivers plying vehicles for site driving should be at least 18yrs old and must hold a valid and current driving license and those who are driving vehicles of engineering plants and dampers should be 21 years old and must hold valid and current driving license issued by the prescribed licensing authority.
                        </p>
                        <p>
                            Driving rules: All drivers to follow the indications given by traffic signs, comply with the traffic control signals.
                        </p>
                        <p>
                            Loading: Vehicles should be loaded as per the loading capacity specified by the manufacturer.
                        </p>
                        <p>
                            Checking: The driver must carry out the specified “checks” of the machinery or vehicles before starting the day’s work. The usual checks are Horn, Emergency brakes, Steering, Wheel brakes, Wiper, electrical lights, tire pressure and water in radiator.
                        </p>
                        <p>
                            Maintenance: The supervisor should ensure the systematic maintenance routine. Basic maintenance on a daily or weekly basis should be done by the drivers.
                        </p>
                        <p>
                            Motor equipment left unattended at night near areas where work is in progress must have appropriate lights, reflectors or barricades to identify the locations of the equipment. A safety tie rack, cage, or equivalent protection must be used when a worker is inflating, mounting, tires installed on split rims or rims equipped with locking rings.
                        </p>
                        <p>
                            Heavy machinery that is suspended or held aloft by the use of slings, hoists, or jacks must be blocked or cribbed to prevent falling or shifting before employees are permitted to work under them. Bulldozer and scraper blades and similar equipment shall be either fully lowered or blocked when being repaired or when not in use. All controls must be in the neutral position and the motor stopped and brakes set, unless work being performed requires otherwise. Parked equipment must be checked and parking brakes set. All cab glass shall be safety glass. All vehicles must have a service brake system, an emergency brake system, and a parking brake system. Vehicles that require additional light shall have at least two headlights, as well as brake lights.
                        </p>
                        <p>
                            Other standard vehicles equipment such as seat belts, rear-view mirrors and safety latches on operating levers shall be in accordance with standard vehicle codes, and state-inspected where appropriate.
                        </p>
                        <p>
                            The following points can be considered as minimum guideline for the transportation within the site.
                        </p>
                        <p>
                            Materials should be properly loaded considering its weight, dimension, capacity of the carrier, center of gravity of load, clearance required for safety, etc.
                        </p>
                        <p>
                            Trailer and other transport vehicles should be in good working conditions.
                        </p>
                        <p>
                            All vehicles must have efficient brakes, horns, lights.
                        </p>
                        <p>
                            The transport vehicles should not be overloaded. No material should project above the height of side panel or beyond the side panels. Materials may be allowed to project maximum 1-1/2 M at the back of deck. Red caution flag or red lamp in the nights should be displayed on the projected end.
                        </p>
                        <p>
                            The vehicle should not ply beyond the permissible speed limit. Speed limits inside site premises should be strictly followed.
                        </p>
                        <p>
                            The driver should observe instructions for crossing the level crossing, overtaking and taking turn, etc.
                        </p>
                        <p>
                            None should get in or get down from a moving vehicle.
                        </p>
                        <p>
                            No one should sit on the sides of the panels or on the top of driver’s cabin.
                        </p>
                        <p>
                            No one should sit near the load or over the load where there is possibility of rolling or shifting due to sudden application of brakes.
                        </p>
                        <h2 id="section-62">
                            HEIGHT SAFETY
                        </h2>
                        <p>
                            Falls of people or objects from a height represents a serious health and safety risk in the Construction Industry. More than half of the falls that occur in the Construction Industry are from heights. Falls can occur from ladders, roofs, scaffold or mobile platforms, when climbing stairs, or from incorrectly erected equipment. A variety of injuries can occur as a result of a fall from height. The injuries range from short-term minor injuries to more permanent, severe disabilities or even death.
                        </p>
                        <p>
                            The following situations are particularly hazardous:
                        </p>
                        <p>
                            Work near unprotected open edges of floors or roofs.
                        </p>
                        <p>
                            Work near unguarded holes, penetrations and voids.
                        </p>
                        <p>
                            Work near unguarded excavations, trenches, shafts, lift wells.
                        </p>
                        <p>
                            Work from unstable structures (for example, incomplete scaffolding).
                        </p>
                        <p>
                            Work on, or near fragile, brittle surfaces (for example, cement sheet roofs, fibre glass roofs, skylight).
                        </p>
                        <p>
                            Work from unprotected formwork decks.
                        </p>
                        <p>
                            Generally, fall protection must be provided for anyone who could fall 1.8 meters or more. However, if the type of work makes it difficult for a worker to be fully aware of the location of the platform edge (for example, welding, Oxy acetylene cutting and other work involving restricted vision) fall protection should be provided regardless of height.
                        </p>
                        <p>
                            The Contractor shall at its cost provide steel scaffolding, staging, guard rails, barricades and safety barriers around all openings and at all edges, temporary stairs and other temporary measures required during construction. The supports for the scaffolding, staging, guard rails, barricades and safety barriers and temporary stairs shall be strong, adequate for the particular situations, tied together with horizontal pieces and braced properly. The temporary access to the various parts of any building under construction shall be rigid and strong enough to avoid any situation of mishaps. The entire scaffolding arrangement together with the staging, guard rails, barricades and safety barriers, and temporary stairs shall be to the Approval of the Project Manager which approval shall not relieve the Contractor of any of its responsibilities, obligations and liabilities for safety and for timely completion of the Works. The use of wooden scaffolding on the Site is strictly forbidden.
                        </p>
                        <h3 id="section-63">
                            Preferred Methods of Preventing Falls
                        </h3>
                        <p>
                            If the risk can’t be eliminated, it should be reduced by:
                        </p>
                        <p>
                            Arranging for the work to be done on ground or on a safe, solid surface (i.e. Solid construction, has a surface which is capable of supporting people, materials and any other loads applied to it)
                        </p>
                        <p>
                            Properly erected scaffolds or perimeter guard railing
                        </p>
                        <p>
                            Other temporary work platforms, such as elevated work platforms (EWP)
                        </p>
                        <p>
                            Other means, such as industrial rope access systems, safety harness etc.
                        </p>
                        <p>
                            Tying of thick rope along the edge of the periphery (life line).
                        </p>
                        <h2 id="section-64">
                            LADDERS
                        </h2>
                        <p>
                            Ladders are primarily a means of access, not a work platform, and should only be used for light work where hand hold and stability can be maintained and only if it is not practicable to use other temporary work platforms.
                        </p>
                        <p>
                            When working on a ladder make sure that:
                        </p>
                        <p>
                            It is placed at a slope of 4 (vertical) to 1 (horizontal).
                        </p>
                        <p>
                            It is on a stable, firm footing and secured top and bottom against movement.
                        </p>
                        <p>
                            Both hands are always used to ascend and descend.
                        </p>
                        <p>
                            All work is done facing the ladder.
                        </p>
                        <p>
                            Only tools that are easily operated with one hand are used.
                        </p>
                        <p>
                            Both feet rest on the ladder and are no higher than the third tread from the top plate of a step ladder or 900 mm from the top of a single or extension ladder.
                        </p>
                        <p>
                            Three limbs are on the ladder where practicable and use tool belts to keep hands free.
                        </p>
                        <p>
                            Over reaching is avoided (the belt buckle should always be within the stiles of the ladder)
                        </p>
                        <p>
                            Work is not conducted above another person.
                        </p>
                        <p>
                            Not more than one person is on the ladder at any time.
                        </p>
                        <h2 id="section-65">
                            SCAFFOLDING
                        </h2>
                        <p>
                            Scaffolding is a temporary structure for supporting access platforms or working platforms. For work above 2.5m above a floor level proper scaffolds need to be erected.
                        </p>
                        <h3 id="section-66">
                            Materials and Supervision
                        </h3>
                        <p>
                            Sufficient sound material must be provided for a scaffold to be strong and stable enough for the job. Wherever timber is used for any kind of scaffolding purpose, it must be of the right type for the job be free from back and must not be painted so that any defects are hidden. Scaffold tubes and fittings must not be bent, distorted or unduly rusty.
                        </p>
                        <p>
                            Scaffolds must be erected, altered or dismantled only under competent supervision and as far as possible, by experienced persons. All scaffolding materials must be inspected before use to check that they are up to standard. All inspected scaffolds must bear a sign “ready for use”.
                        </p>
                        <h3 id="section-67">
                            Standards or Uprights, Ledgers and Putlogs
                        </h3>
                        <p>
                            Scaffold standards should be vertical and spaced closely enough for the intended use of the scaffold.
                        </p>
                        <p>
                            Base plates must be used. Timber sole plates should also be used to distribute the load from the standard over a wide area, as well as to offset possible local subsidence.
                        </p>
                        <p>
                            Ledgers must be level and fixed to standards with right-angle couplers.
                        </p>
                        <p>
                            Putlogs and transoms must be firmly fixed to ledgers or standards.
                        </p>
                        <p>
                            The flattened end of the putlog must be pushed right into the wall to provide maximum support.
                        </p>
                        <p>
                            Putlogs and transoms should be spaced according to the expected load and the thickness of the boards to be used in the platform.
                        </p>
                        <p>
                            In normal use, putlogs and transoms should be spaced so that the spans of scaffold boards should not be greater than:
                        </p>
                        <p>
                            32mm boards: 1m
                        </p>
                        <p>
                            38mm boards: 1.50 m
                        </p>
                        <p>
                            50mm boards: 4.60 m
                        </p>
                        <p>
                            Work on any scaffold shall allow only if
                        </p>
                        <p>
                            On a stable, level foundation with proper base plates.
                        </p>
                        <p>
                            Complete, properly braced and tied to the supporting structure.
                        </p>
                        <p>
                            Not overloaded (225 kg max. per platform, per bay for light duty scaffold) (450 kg max. per platform, per bay for medium duty) (675kg max per platform, per bay for heavy duty).
                        </p>
                        <p>
                            Fully planked and fitted with guardrails, mid-rails and toeboards on the working deck wherever a person or material could fall more than 1.8 metres.
                        </p>
                        <p>
                            Fitted with a safe, secure temporary stairway or ladder to access the working deck.
                        </p>
                        <p>
                            Scaffolding components must not be located within 4.0 metres of any conductors of an overhead electrical power line.
                        </p>
                        <p>
                            A tag mentioning “Scaffold Incomplete/Do Not Use” must be put on defective or incomplete scaffolding and the same shall not be used for any activity.
                        </p>
                        <h3 id="section-68">
                            Additional Requirements for Mobile Scaffolds
                        </h3>
                        <p>
                            Follow the manufacturers/suppliers written instructions for erection, use and dismantling.
                        </p>
                        <p>
                            Mobile scaffolds should be used only on a hard, level surface.
                        </p>
                        <p>
                            The wheels of a mobile scaffold should be locked against any possible movement. before using the scaffold, and should remain locked when not in use.
                        </p>
                        <p>
                            Do not relocate a mobile scaffold unless all items have been secured against falling.
                        </p>
                        <p>
                            No person should be on a mobile scaffold when it is being moved.
                        </p>
                        <p>
                            All mobile scaffolds should have a safe, secure means of access to the working platform.
                        </p>
                        <p>
                            Do not locate a mobile scaffold closer than 1 metre to any slab edge, penetration or other step down, unless a positive means to prevent it crossing that point, such as a fixed fence, rail or raised edge, is in place.
                        </p>
                        <p>
                            When moving a mobile scaffold, stay well clear of power lines (the highest part of the scaffold should come no closer than 4m).
                        </p>
                        <h3 id="section-69">
                            Suspended Scaffolds
                        </h3>
                        <p>
                            Before using a Suspended Scaffold make sure that:
                        </p>
                        <p>
                            A written hand-over certificate has been provided by the installer.
                        </p>
                        <p>
                            Operators have written authorization from their employer and are suitably trained.
                        </p>
                        <p>
                            It has had its daily pre-operational check as set out in the operator’s manual.
                        </p>
                        <p>
                            The cradle is not overloaded above its rated safe working load.
                        </p>
                        <p>
                            The cradle has meshed guardrails and solid flooring to ensure that materials cannot fall through.
                        </p>
                        <p>
                            The area below the cradle is protected by a catch platform or is isolated so no-one can be injured from falling material or debris.
                        </p>
                        <p>
                            There are suitable lateral restraints to stabilize the cradle during use.
                        </p>
                        <p>
                            Where access to and from the cradle cannot be gained from the ground or a protected platform, the cradle must be securely tied to the building and properly anchored safety harness and lanyards must be worn and used when climbing in and out of the cradle.
                        </p>
                        <p>
                            Suspended scaffolds should be subject to weekly inspections by a competent
                        </p>
                        <p>
                            person, in addition to daily operator’s checks.
                        </p>
                        <p>
                            Cantilever, Jib figure and Bracket scaffolds:
                        </p>
                        <p>
                            Cantilever or jib scaffolds must be anchored to a structure which is strong enough to carry the total load Outriggers must be long enough and strong enough and the scaffold must be braced to ensure stability.
                        </p>
                        <p>
                            Figure or bracket scaffolds supported by dogs or spikes must not be used if there is any danger of these pulling out of the brickwork or stone-work.
                        </p>
                        <h2 id="section-70">
                            CRANES, HOISTS AND LOAD SHIFTING EQUIPMENT
                        </h2>
                        <p>
                            Safety is critical in the operation of plant and equipment such as cranes, forklifts, elevating work platforms, excavators, backhoes, hoists etc. When any plant is to be used on site, an employer must ensure that the risks to health and safety arising from plant in use and systems of work associated with the plant are minimized. A certificate of competency as per the rules and regulations pertaining to the respective plant and machinery to be submitted by the contractor.
                        </p>
                        <h3 id="section-71">
                            Mobile Plant Safety
                        </h3>
                        <p>
                            Mobile Plant must meet the same criteria for all other plant, including:
                        </p>
                        <p>
                            Making sure that it is serviced and maintained in accordance with the manual and that current records are kept.
                        </p>
                        <p>
                            The system for the daily inspection of the plant.
                        </p>
                        <p>
                            Risk assessment for the use of the plant at your site.
                        </p>
                        <p>
                            The provision of the relevant safety equipment for use, i.e. Harness, flashing lights, beepers, reversing alarms etc.
                        </p>
                        <p>
                            Visual inspection prior to first use.
                        </p>
                        <p>
                            Forklifts and earthmoving equipment should be fitted with overhead protective devices to stop objects falling on the operator and roll over protection (ROPS).
                        </p>
                        <p>
                            Always obey the rules for operating mobile plan near overhead power lines.
                        </p>
                        <h3 id="section-72">
                            Crane Safety
                        </h3>
                        <p>
                            Only persons with a relevant Certificate of Competency can operate cranes.
                        </p>
                        <p>
                            All cranes should be subject to a daily checklist/ logbook completed by the operator.
                        </p>
                        <p>
                            Make sure that the set up area has been inspected for potential hazards and that inspection is documented.
                        </p>
                        <p>
                            Make sure the counterweight slewing area is clear of obstacles and is barricaded.
                        </p>
                        <p>
                            Make sure that loads do not pass overhead workers.
                        </p>
                        <h3 id="section-73">
                            Lifting Gear
                        </h3>
                        <p>
                            All lifting gear (shackles, slings, wire rope) should be inspected regularly by a qualified and competent person. The inspection details should be recorded and the item tagged.
                        </p>
                        <p>
                            Load hooks should be fitted with a safety catch, particularly where there is a chance of the slings being displaced.
                        </p>
                        <h3 id="section-74">
                            Safe Operation of Earthmoving Equipment
                        </h3>
                        <p>
                            Operators must be suitably qualified.
                        </p>
                        <p>
                            Never carry passengers unless there is a passenger seat fitted.
                        </p>
                        <p>
                            Always wear the seatbelt (where fitted).
                        </p>
                        <p>
                            Always take care to know your operating area – never back up until you are certain it is safe • Always shut down the plant and remove the ignition key when you leave the machine unattended.
                        </p>
                        <p>
                            Ground your attachments and booms before vacating the machine.
                        </p>
                        <p>
                            Know the machine’s roll-over limits and stay well within them.
                        </p>
                        <p>
                            Stay a safe distance away from the edge of embankments. Be sure that the boundaries of your operating area are clearly marked.
                        </p>
                        <p>
                            When descending a grade, use the same gear you would use to climb it.
                        </p>
                        <p>
                            Always obey speed limit restrictions.
                        </p>
                        <p>
                            Operators to wear high visibility vests at all times.
                        </p>
                        <h3 id="section-75">
                            Safe Operation of Forklifts
                        </h3>
                        <p>
                            Operators must hold a Fork-lift Certificate of Competency (LF)
                        </p>
                        <p>
                            Passengers must never be carried on forklift trucks.
                        </p>
                        <p>
                            Always wear the seatbelt (where fitted).
                        </p>
                        <p>
                            Lower the load before travelling and/or turning.
                        </p>
                        <p>
                            When travelling, lower the fork as close to the ground as is practicable.
                        </p>
                        <p>
                            Forklifts should never be used over terrain for which they have not been designed
                        </p>
                        <p>
                            When leaving the forklift unattended, lower the tines, turn the gas bottles off and remove the ignition key.
                        </p>
                        <h3 id="section-76">
                            Safety of Hoist ways, Platform and Cage:
                        </h3>
                        <p>
                            Hoist ways must be enclosed wherever access is provided or wherever persons could be struck by the platform or other moving parts. Gates must be fitted in the enclosure at all landing places and must normally be at least 2m high, but gates 910 mm high are acceptable where persons are not at the risk of falling down the hoist-ways or coming into contact with moving parts. Gates must be kept closed except for the movement of persons and materials; it is the duty of all persons to see that this id done
                        </p>
                        <p>
                            Hoists platforms and cages must be fitted with a device capable of supporting them, fully loaded, should hoists, ropes or driving gear fail. Hoists must be fitted with ver- run stops at the top.
                        </p>
                        <h3 id="section-77">
                            Operation of Hoists
                        </h3>
                        <p>
                            Hoists must only be capable of being operated from one position at a time, whether by rope, lever or switch. Hoists must not be operated from the cage.
                        </p>
                        <p>
                            Where the hoist driver cannot see the platform or cage during it s movement, a signaling system, which covers all landing places, must be used.
                        </p>
                        <p>
                            The platform of materials or goods hoists must carry a notice stating the safe working load and that the passenger must not ride on platform
                        </p>
                        <p>
                            The safe working load must not be exceeded except for test purposes.
                        </p>
                        <p>
                            Cages for passenger’s hoists must carry a notice stating the safe working load and the number of passengers permitted.
                        </p>
                        <p>
                            No greater number of passengers may be carried and safe working load must not be exceeded except for the test purposes.
                        </p>
                        <h2 id="section-78">
                            BARRICADES
                        </h2>
                        <p>
                            Contractor shall at its cost erect and maintain barricades required in connection with its operation to guard or protect,
                        </p>
                        <p>
                            Hoisting areas.
                        </p>
                        <p>
                            Areas adjudged hazardous by contractor’s safety management and/ or Project Manager’s Inspectors.
                        </p>
                        <p>
                            Owner’s existing property subject to damage by the contractor’s operations.
                        </p>
                        <h3 id="section-79">
                            Guarding of floor opening and floor holes
                        </h3>
                        <p>
                            Every temporary floor opening shall be guarded by either by a railing with toe board on all exposed sides, or a floor hole cover of adequate strength and it should be hinged in place.
                        </p>
                        <p>
                            Barricades must be strong enough to carry the weight of people.
                        </p>
                        <p>
                            Every stairway floor opening shall be guarded by a railing on all exposed sides, except at entrance to stairway. Every ladder way floor opening or platform shall be
                        </p>
                        <p>
                            guarded by a guard railing with toe board on all exposed sides (except at entrance to opening) with the passage through the railing either provided with a swinging gate or so offset that a person can not directly into the opening.
                        </p>
                        <h3 id="section-80">
                            Guarding if open-side floors and platform
                        </h3>
                        <p>
                            Every open-sided floor or platform 120cm or more above adjacent floor or ground level shall be guarded by a railing (or the equivalent) or all open sides except where there is entrance to ramp, stairway or fixed ladder. The railing shall be provided with a toe board beneath the open sides wherever,
                        </p>
                        <p>
                            Persons may pass,
                        </p>
                        <p>
                            There is moving machinery and
                        </p>
                        <p>
                            There is equipment with which failing materials could create a hazard
                        </p>
                        <h2 id="section-81">
                            EXCAVATION AND SHORING
                        </h2>
                        <p>
                            All trenches and excavations should be made safe and provided with a ground support system, a steel shield or all walls to be benched or battered back at a safe angle.
                        </p>
                        <p>
                            Prior to excavating, a site investigation should be carried out to determine:
                        </p>
                        <p>
                            Nature of the ground (soil type, rock, water table)
                        </p>
                        <p>
                            Possibility of flooding from any water source.
                        </p>
                        <p>
                            The existence of underground services (gas, electricity, pipelines, sewer)
                        </p>
                        <p>
                            Proximity of other excavations and other point sources of instability
                        </p>
                        <p>
                            The possibility of natural or artificial hazards (e.g. ground contamination)
                        </p>
                        <p>
                            A risk assessment for all trenching/excavation tasks should be completed based on the results of the site investigation. The risk assessment should include control measures for the safe use of excavation plant.
                        </p>
                        <p>
                            Employees should be made aware of the risk assessment relevant to their trenching or excavation work.
                        </p>
                        <p>
                            All trenching and excavation operations should undergo a daily checklist system to ensure that the following safety requirements are observed:
                        </p>
                        <p>
                            No person enters an unsupported section.
                        </p>
                        <p>
                            Trenching supports are appropriate to the conditions. (i.e. The need or otherwise for trench shields, close sheeting, benching or battering)
                        </p>
                        <p>
                            Soil heaps are properly positioned at least 0.9 metres from the edges of the trench Safe ladder access is provided into the trench.
                        </p>
                        <p>
                            All workers wear safety helmets.
                        </p>
                        <p>
                            No person is working alone in an excavation.
                        </p>
                        <p>
                            Persons do not remain in close proximity to where an excavator is operating.
                        </p>
                        <p>
                            Workers in excavations are not exposed to an accumulation of hazardous fumes including fumes from petrol or diesel vehicles.
                        </p>
                        <h2 id="section-82">
                            HANDLING AND STORAGE OF MATERIALS
                        </h2>
                        <h3 id="section-83">
                            Cement
                        </h3>
                        <p>
                            Storage and stacking:
                        </p>
                        <p>
                            Cement shall be stored at the work site in a building or a shed which is dry, leak proof and moisture proof. The building or shed for storage should have minimum number of windows and close fitting doors and these should be kept closed.
                        </p>
                        <p>
                            Cement received in bags shall be kept in such a way that the bags are kept free from the possibility of any dampness or moisture coming in contact with them. Cement bags shall be stacked off the floor on wooden planks in such a way as to keep them 150 to 200mm clear from the floor and space of 450mm minimum shall be left all round between the exterior walls and in the stacks. In the stacks the cement shall be kept close together to reduce circulation of air as much as possible. Owing to pressure on bottom layer of bags sometimes ‘warehouse pack’ is developed in these bags. This can be removed easily by rolling the bags when cement is taken out for use.
                        </p>
                        <p>
                            The height of stack shall not be more than 15 bags to prevent the possibility of lumping up under pressure. The width of the stack shall be not more than four bags length or 3m. In stacks more than eight bags high, the cement bags shall be arranged alternately lengthwise and crosswise so as to tie the stacks together and minimize the danger of toppling over.
                        </p>
                        <p>
                            For extra safety during monsoon or when it is expected to store for an unusually long period, the stack shall be completely enclosed by a water proofing membrane such as polyethylene, which shall close on the top of the stack. Care shall be taken to see that the waterproofing membrane is not damaged any time during the use.
                        </p>
                        <p>
                            Drums or other heavy containers of cement shall not be stacked more than two layers high.
                        </p>
                        <p>
                            The manner of storage shall facilitate the requirement that lots of cement received are removed and used more or less in the order in which they are received.
                        </p>
                        <p>
                            Handling
                        </p>
                        <p>
                            Hooks shall not be used for handling cement bags unless specifically permitted by the engineer-in-charge.
                        </p>
                        <h3 id="section-84">
                            Polyethylene pipes
                        </h3>
                        <p>
                            Storage &amp; stacking:
                        </p>
                        <p>
                            Black polyethylene pipes may, be stored either under cover or in the open. Natural polyethylene pipes however, should be stored under cover and protected from direct sunlight.
                        </p>
                        <p>
                            Coils may be stored either on edge or stacked flat one on top of the other, but in either case they should not be allowed to come into contact with hot water or steam pipes and should be kept away from hot surface. Straight lengths should be stored on horizontal racks giving continuous support to prevent the pipe taking on a permanent set.
                        </p>
                        <p>
                            Storage of pipes in heated areas exceeding 270 C should be avoided. Handling:
                        </p>
                        <p>
                            Removal of pipe from a pile shall be accomplished by working from the ends of the pipe.
                        </p>
                        <h3 id="section-85">
                            Pipes of conducting materials
                        </h3>
                        <p>
                            Storage and stacking:
                        </p>
                        <p>
                            Pipes shall be stacked on solid level sills and contained in a manner to prevent spreading or rolling of the pipe. Where quantity storage is necessary suitable packing shall be placed between succeeding layers to reduce the pressure and resulting spreading of the pile.
                        </p>
                        <p>
                            In stacking and handing of pipes and other conducting materials the following minimum safety distances shall be ensured from the overhead power line:
                        </p>
                        <p>
                            11KV and below 40m
                        </p>
                        <p>
                            Above 11and below 33KV 60m
                        </p>
                        <p>
                            Above 33 and below 132KV 70m
                        </p>
                        <p>
                            Above 132 and below 275KV 70m
                        </p>
                        <p>
                            Above 275and below 400KV 50m Handling:
                        </p>
                        <p>
                            Removal of pipes from a pile shall be accomplished by working from the ends of the pipe. During transportation, the pipes shall be so secured as to ensure against displacement.
                        </p>
                        <h3 id="section-86">
                            Paints, Varnishes and Thinners
                        </h3>
                        <p>
                            Storage and stacking:
                        </p>
                        <p>
                            Paints, varnishes lacquers, thinners and other flammable materials shall be kept in properly sealed or closed containers. The containers shall be kept in a well ventilated location, free from excessive heat, smoke, sparks or flame. The floor of the paint stores shall be made up of 10cm thick loose sand and stored in a collection drip pan to prevent leakage’s to the ground and/or the soil.
                        </p>
                        <p>
                            Paint materials in quantities other than required for daily use shall be kept stocked under regular storage place.
                        </p>
                        <p>
                            Where the paint is likely to deteriorate with age the manner of storage shall facilitate removal and use if lots in the same order in which they are received.
                        </p>
                        <p>
                            Temporary electrical wiring / fittings shall not be installed in the paint store. When electric lights, switches or electrical equipment are necessary, they shall be of explosion proof design.
                        </p>
                        <p>
                            Handling:
                        </p>
                        <p>
                            Ventilation shall be adequate to prevent the accumulation of flammable vapors to hazardous levels of concentration shall be provided in all areas where painting is done.
                        </p>
                        <p>
                            When painting is done in confined spaces where flammable or explosive vapors may develop any necessary heat shall be provided through duct work remote from the source of flame.
                        </p>
                        <p>
                            Sources of ignition such as open flame and exposed heating elements shall not be permitted in area or rooms where spray painting is done nor shall smoking be allowed there.
                        </p>
                        <p>
                            Care should be taken not to use any naked flame inside the paint store. Buckets containing sand shall be kept ready for use in case of fire. Fire extinguisher when required shall be of foam type confirming to accepted standards.
                        </p>
                        <p>
                            Each workman handling lead based paints shall be issued ½ liter milk per day for his personal consumption.
                        </p>
                        <h3 id="section-87">
                            Bitumen, Road Tar, Asphalt
                        </h3>
                        <p>
                            Storage and stacking:
                        </p>
                        <p>
                            Drums or containers containing all types of bitumen, road tar, asphalt etc. shall be stacked vertically on their bottoms in up to 3 tiers. Leaky drums shall be segregated and either their contents shall be emptied into intact drums or contained in larger containers. All spillages or leakages onto natural soil shall be immediately cleaned up and placed in a contained area. Empty drums shall be stored in pyramidal stacks neatly in rows.
                        </p>
                        <p>
                            Handling:
                        </p>
                        <p>
                            Bitumen / Tar – Bitumen / tar shall not be heated beyond the temperature recommended by the manufacturer of the product. While discharging heated binder from the boiler, workers shall not stand opposite to the jet so as to avoid the possibility of hot binder falling on them. The container shall be handled only after closing the control valve. While handling hot bitumen / tar, workers shall exercise scrupulous care to prevent accidental spillage thereof. The buckets and cans in which the hot material is carried from boiler shall be checked before use to ensure that they are intact and safe. Mops and other applicators contaminated with bituminous materials shall not be stored inside buildings
                        </p>
                        <h3 id="section-88">
                            Bituminous roofing felts
                        </h3>
                        <p>
                            Storage and stacking:
                        </p>
                        <p>
                            Bituminous roofing felts shall be stored away from other combustible, flammable materials. For long storage it shall be kept under shade.
                        </p>
                        <p>
                            Handling:
                        </p>
                        <p>
                            Bituminous roofing felts should be handled in a manner to prevent cracking and other damages
                        </p>
                        <h3 id="section-89">
                            Flammable materials
                        </h3>
                        <p>
                            Storage and stacking:
                        </p>
                        <p>
                            In addition the following provisions shall also apply:
                        </p>
                        <p>
                            Outdoor storage of drums required some care to avoid contamination because moisture and dirt in hydraulic brake and transmission fluid, gasoline or lubricants may cause malfunction of failure or equipment with possible danger to personnel. The storage area should be free of accumulations of spilled products, debris and other hazards and compressed gases and petroleum products shall not be stored in the same building or close to each other.
                        </p>
                        <p>
                            Handling:
                        </p>
                        <p>
                            Petroleum products delivered to the job site and stored there in drums shall be protected during handling to prevent loss of identification through damage to drum markings, tag, etc. Unidentifiable petroleum products may result in improper use with possible fire hazard damage to equipment or operating failure.
                        </p>
                        <p>
                            Workmen shall be required to guard carefully against any part their clothing becoming contaminated with flammable fluids. They shall not be allowed to continue work when their clothing becomes so contaminated. All flammable and toxic liquids shall be stored in suitable collecting drip pans to avoid spill contamination into the ground/soil.
                        </p>
                        <h2 id="section-90">
                            ELECTRICAL SAFETY
                        </h2>
                        <p>
                            The National Indian electric codes and regulations shall apply to all permanent and temporary electrical installations. All wires shall be color coded in accordance with the national codes and all temporary power systems shall be properly earthed. Periodic inspections and maintenance to be done to keep all the electric tool and system in proper operating condition.
                        </p>
                        <h3 id="section-91">
                            Plugs and Fuses
                        </h3>
                        <p>
                            The electricity supply to the tool must be drawn from the socket outlet only, into which a plug is inserted. The fuse rating should not exceed twice the normal load current of the tool as indicated in the rating plate.
                        </p>
                        <h3 id="section-92">
                            Electrical installations
                        </h3>
                        <p>
                            Following points are to be considered as guide lines during electrical installation fixing:
                        </p>
                        <p>
                            Electrical appliances and outlets should be marked clearly to indicate their purpose and voltage.
                        </p>
                        <p>
                            Bare conductors or other bare current carrying parts of equipment should not be permitted unless adequate precautions are taken to prevent direct or indirect contact for example by fencing, screening or positioning.
                        </p>
                        <p>
                            Lamps and lamp fittings for general lighting should be installed not less than
                        </p>
                        <p>
                            2.5 m above the ground or floor wherever practicable.
                        </p>
                        <p>
                            Since electrical fittings are easily damaged by the rough work and severe conditions prevailing on sites, fittings should be of weatherproof type.
                        </p>
                        <p>
                            Flexible cables used for portable apparatus should have an earthing conductor.
                        </p>
                        <p>
                            All wiring should be supported on proper insulated supports and not looped/twisted over nails, etc.
                        </p>
                        <p>
                            Overhead lines should be carried on support of adequate strength and at a height that prevents contact with persons or equipment passing underneath.
                        </p>
                        <p>
                            Flexible cables should not be used to lift a portable tool.
                        </p>
                        <p>
                            Motors, switch gears and distribution apparatus should be protected against dripping and splashing water, particularly in pump rooms.
                        </p>
                        <p>
                            Fuses, motors, gears, etc, should bear clear marking of the specifications indicating their current rating and whether they are of the fast or slow braking type and as far as possible their rated braking capacity.
                        </p>
                        <p>
                            Hand lamps should be equipped with a strong cover of glass or other transparent material and portable lamp holders should have all current carrying parts enclosed with an insulated handle.
                        </p>
                        <p>
                            All electrical equipment should be inspected before it is used to ensure that it is suitable for its proposed use.
                        </p>
                        <p>
                            All conductors and equipment should be considered to be live unless there is certain proof to the contrary.
                        </p>
                        <p>
                            Temporary connections are to be given as per standard practice and should be disconnected after completing the work for which it is laid.
                        </p>
                        <h3 id="section-93">
                            Electrical Works
                        </h3>
                        <p>
                            All work connected with electricity operated equipment and electric power supply should be done by a licensed electrician only. Motors, gears, transmission electric wiring and other dangerous part of electrically operated equipment should have safe guards for preventing free access of workers to such parts. Proper warning signs should be displayed wherever live circuits exist near work area.
                        </p>
                        <h2 id="section-94">
                            CONCRETE CONSTRUCTION
                        </h2>
                        <h3 id="section-95">
                            Mixers
                        </h3>
                        <p>
                            All gears, chains and rollers of mixers shall be properly guarded. If the mixer has a charging skip the operator shall ensure that the workmen are out of danger before the skip is lowered. Railings shall be provided on the ground to prevent anyone walking under the skip while it is being lowered.
                        </p>
                        <p>
                            All cables, clamps, hooks, wire ropes, gears and clutches etc. of the mixer, shall be checked and cleaned, oiled and greased and service once a week. A trial run of the mixer shall be made and defects shall be removed before operating a mixer.
                        </p>
                        <p>
                            When workmen are cleaning the inside of the drums and operating power of the mixer shall be locked in the off position and all fuses shall be removed and a suitable notice hung at the place.
                        </p>
                        <h3 id="section-96">
                            Trucks
                        </h3>
                        <p>
                            When trucks are being used on the site, traffic problems shall be taken care of. A reasonably smooth traffic surface shall be provided. If practicable, a loop road shall be provided to permit continuous operation of vehicles and to eliminate their backing. If a continuous loop is not possible a turnout shall be provided. Backing operations shall be controlled by a signalman positioned so as to have a clear view of the area behind the truck and to be clearly visible to the truck driver. Movement of workmen and plant shall be routed to avoid crossing as much as possible the truck lanes.
                        </p>
                        <h3 id="section-97">
                            Formwork
                        </h3>
                        <p>
                            Formwork shall be designed after taking into considering spans, setting temperature of concrete, dead load and working load to be supported and safety factor for the material used for formwork.
                        </p>
                        <p>
                            All timber formwork shall be carefully inspected before use and members having cracks and excessive knots shall be discarded
                        </p>
                        <p>
                            The vertical supports shall be adequately braced or otherwise secured in position that these do not fall when the load gets released or the supports are accidentally hit.
                        </p>
                        <p>
                            Tubular steel centering shall be used in accordance with the manufacturer’s instructions. When tubular steel and timber centering is to be used in combination necessary precautions shall be taken to avoid any unequal settlement under load.
                        </p>
                        <p>
                            All centering shall be finally inspected to ensure that:
                        </p>
                        <p>
                            Footings or sills under every post of the centering are sound
                        </p>
                        <p>
                            All tower adjustment screws or wedges are snug against the legs of the panels.
                        </p>
                        <p>
                            All upper adjustment screws or heads of jacks are in full contact with the formwork.
                        </p>
                        <p>
                            Panels are plumb in both directions.
                        </p>
                        <p>
                            All cross braces are in place and locking devices are in closed and secure position.
                        </p>
                        <p>
                            In case of chajjas and balconies the props shall be adequate to transfer the load to the supporting point.
                        </p>
                        <h3 id="section-98">
                            Ramps and gangways
                        </h3>
                        <p>
                            Ramps and gangways shall be of adequate strength and evenly supported. They shall either have a sufficiently flat slope or shall have cleats fixed to the surface to prevent slipping of workmen. Ramps and gangways shall be kept free from grease, mud, snow or other slipping hazards or other obstructions leading to tripping and accidental fall of workman.
                        </p>
                        <p>
                            Ramps and gangways meant for transporting materials shall have even surface and be of sufficient width and provided with skirt boards on open sides.
                        </p>
                        <h3 id="section-99">
                            Pre-stressed concrete
                        </h3>
                        <p>
                            In pre-stressing operations, operating, maintenance and replacement instructions of the supplier of the equipment shall be strictly adhered to.
                        </p>
                        <p>
                            Necessary shields should be put up immediately behind the pre-stressing jacks during stressing operations.
                        </p>
                        <p>
                            Wedges and other temporary anchoring devices shall be inspected before use. The pre-stressing jacks shall be periodically examined for wear and tear.
                        </p>
                        <p>
                            A spreader beam shall be used wherever possible so that the cable can be as perpendicular to the members being lifted as practical. The angle between the cable and the members to be lifted shall not be less than 600.
                        </p>
                        <p>
                            Methods of assembly and erection specified by the designer shall be strictly adhered to at site. Immediately on erecting any unit in position, temporary connections or supports as specified shall be provided before releasing the lifting equipment. The permanent structural connections shall be established at the earliest opportunity.
                        </p>
                        <h2 id="section-100">
                            MASONARY WORKS
                        </h2>
                        <p>
                            General: Depending on the type of wall to be constructed the height of construction per day shall be restricted to ensure that the newly constructed wall does not come down due to lack of strength in the lower layers. Similarly, in long walls adequate expansion / crumple joints shall be provided to ensure safety.
                        </p>
                        <p>
                            Opening in walls: Whenever making of an opening in the existing walls is contemplated, adequate supports against the collapse or cracking of the wall portion above or roof or adjoining walls shall be provided.
                        </p>
                        <p>
                            Guarding of wall openings and Holes: Wall opening barriers and screens shall be of such construction and mounting that they are capable of withstanding the intended loads safely. For detailed information reference may be made to good practice. Every wall opening from which there is a drop of more than 120mm shall be one of the following:
                        </p>
                        <p>
                            Rail, roller, picket fence, half door or equivalent barrier: The guard may be removable but should be preferable be hinged or otherwise mounted so as to be conveniently replaceable. Where there is danger to persons working or passing below on account of the falling materials, a removable toe board or the equivalent shall also be provided. When the opening is not in use for handling materials the guards shall be kept in position regardless of a door in the opening. In addition a grab handle shall be provided on each side of the opening. The opening should have a sill that projects above the floor level at least 2.5cm.
                        </p>
                        <p>
                            Extension platform into which materials may be hoisted for handling, shall be of full length of the opening shall be of full length of the opening and shall have side rails or equivalent guards.
                        </p>
                        <p>
                            Every chute wall opening from which there is a drop of more than 120mm shall be guarded by one or more of the barriers specified in 16.2.1 or as required by the conditions.
                        </p>
                        <h2 id="section-101">
                            HEALTH &amp; HYGIENE STANDARDS
                        </h2>
                        <h3 id="section-102">
                            Drinking water
                        </h3>
                        <p>
                            In every work place, there shall be provided and maintained at suitable places, easily accessible to labour, a sufficient supply of cold water fit for drinking.
                        </p>
                        <p>
                            Where drinking water is obtained from an intermittent public water supply, each work place shall be provided with storage where such drinking water shall be stored.
                        </p>
                        <p>
                            Every water supply or storage shall be at a distance of not less than 50 feet from any latrine drain or any other source of pollution.
                        </p>
                        <h3 id="section-103">
                            Washing facilities
                        </h3>
                        <p>
                            In every work place adequate and suitable facilities for washing shall be provided and maintained for the use of contract labour employee therein
                        </p>
                        <p>
                            Separate and adequate cleaning facilities shall be provided for the use of male and female workers
                        </p>
                        <p>
                            Such facilities shall be conveniently accessible and shall be kept in clean and hygienic condition.
                        </p>
                        <h3 id="section-104">
                            Latrines and Urinals
                        </h3>
                        <p>
                            Latrines shall be provided in every work place on the following scale namely:
                        </p>
                        <p>
                            Where females are employed there shall be at least one latrine for every 25 females.
                        </p>
                        <p>
                            Where males are employed there shall be at least one latrine for every 25 males.
                        </p>
                        <p>
                            Provided that where the number of males or females exceeds 100, it shall be sufficient if there is one latrine for 25males or females as the case may be upto first 100 and one for every 50 thereafter.
                        </p>
                        <p>
                            Every latrine shall be under cover and so partitioned off as to secure privacy and shall have proper door and fastenings.
                        </p>
                        <p>
                            Construction of latrines: The inside walls shall be constructed of masonry or some suitable heat-resisting non-absorbent materials and shall be cement washed inside and outside at least once a year, latrines shall not be of standard lower than borehole system.
                        </p>
                        <p>
                            Where workers of both sexes are employed, there shall be displayed out side each block of latrine and urinal a notice in the language understood by the majority of the workers “for men only” or for” women only” as the case may be.
                        </p>
                        <p>
                            The notice shall also bear the figure of man or woman as the case may be.
                        </p>
                        <p>
                            There shall be at least one urinal for male workers upto 50 and for female workers upto 50 employed at a time, provided that where the number of male or female workers as the case may exceed 500 it shall be sufficient if there is one urinal for every 50 males or females upto the first 500 and one for every 100 or part thereafter.
                        </p>
                        <p>
                            The latrines and urinals shall be adequately lighted and shall be maintained in a clean and sanitary condition at all times
                        </p>
                        <p>
                            Latrines and urinals other than those connected with flush sewage system shall comply with the requirements of Public Health Authorities.
                        </p>
                        <p>
                            Water shall be provided by means of tap or otherwise so as to conveniently accessible in or near the latrines and urinals.
                        </p>
                        <p>
                            Disposal of excreta: Unless otherwise arranged by the local sanitary authority, arrangements for proper disposal of excreta by incineration at the work place shall be made by means of a suitable incinerator. Alternately excreta may be disposed of by putting a layer of night soil at the bottom of pucca tank prepared for the purpose and covering it with 15cm layer of waste or refuse and then covering it with a layer of earth for a fortnight (then it will turn to manure). Alternatively, the contractor shall provide movable toilet cabins. The sewage collected in the sewage tanks fitted with the toilet cabins shall be evacuated every day.
                        </p>
                        <p>
                            The contractor shall at his own expense, carry out all instructions issued to him by the Engineer-in-charge to effect proper disposal of night soil and other conservancy work in respect of the contractor’s workmen or employees of the site. The contractor shall be responsible for payment of any charges which may be levied by the municipal or cantonment authority for execution of such on behalf.
                        </p>
                        <h3 id="section-105">
                            Provision of shelter during rest
                        </h3>
                        <p>
                            At every place there shall be provided free of cost, for suitable sheds two for meals and other two for rest separately for the use of men and women labour. The height of each shelter shall not be less than 3m from the floor level to the lowest part of the shed roof. These shall be kept clean and the space provided shall be on the basis of 0.6sqm per head.
                        </p>
                        <p>
                            Provided that the engineer-in-charge may permit subject to its satisfaction, a portion of building under construction or other alternative accommodation to be used for the purpose.
                        </p>
                        <h3 id="section-106">
                            Canteens
                        </h3>
                        <p>
                            In every work place where the work regarding the employment of contract labour is likely to continue for six months and where in contract labour numbering 100 or more are ordinarily employed an adequate canteen shall be provided by the contractor for the use of such labour.
                        </p>
                        <p>
                            The canteen shall be maintained by the contractor in an efficient manner.
                        </p>
                        <p>
                            The canteen shall consist of at least a dining hall, kitchen, storeroom, pantry and washing places separately for workers and utensils.
                        </p>
                        <p>
                            The floor shall be made of smooth and impervious materials and inside walls shall be lime washed or colour washed at least once a year. Provided that the inside walls of the kitchen shall be lime washed every four months.
                        </p>
                        <p>
                            The premises of the canteen shall be maintained in a clean and sanitary condition Suitable arrangements shall be made for the collection of disposal of garbage.
                        </p>
                        <p>
                            Waste water shall be carried away in suitable covered drains and shall not be allowed to accumulate so as to cause nuisance.
                        </p>
                        <p>
                            The dining hall shall accommodate at a time 30% of the contract labour working at a time.
                        </p>
                        <p>
                            The floor area of the dining hall, excluding the area occupied by the service counter and any furniture except tables and chairs shall not to be less than 1sqm per diner to be accommodated as prescribed in sub-rule (i)
                        </p>
                        <p>
                            There shall be provided and maintained sufficient utensils crockery, furniture and any other equipment necessary for efficient running of canteen
                        </p>
                        <p>
                            The furniture, utensils and other equipment shall be maintained in a clean and hygienic condition.
                        </p>
                        <p>
                            Suitable clean clothes for the employees serving in the canteen shall be provided and maintained.
                        </p>
                        <p>
                            A service counter, if provided shall have top of smooth and impervious material.
                        </p>
                        <p>
                            Suitable facilities including an adequate supply of hot water shall be provided for the cleaning of utensils and equipment.
                        </p>
                        <p>
                            A portion of the dining hall and service counter shall be partitioned off and reserved for women workers in proportion to their number.
                        </p>
                        <p>
                            Sufficient tables stools or benches shall be available for the number of diners to be accommodated as prescribed herein
                        </p>
                        <p>
                            The food stuff and other items to be served in the canteen shall be in conformity with the normal habits of the contract labour.
                        </p>
                        <p>
                            The charges of food stuffs, beverages and other items served in the canteen shall
                        </p>
                        <p>
                            be based on ‘No profit no loss’ and shall be conspicuously displayed in the canteen.
                        </p>
                        <p>
                            In arriving at the price of the foodstuffs and other article served in the canteen, the following items shall not be taken in to consideration as expenditure namely:
                        </p>
                        <p>
                            The rent of land and building
                        </p>
                        <p>
                            The depreciation and maintenance charges for the building and equipment provided for the canteen.
                        </p>
                        <p>
                            The purchase, repairs and replacement of equipment including furniture, crockery, cutlery and utensils.
                        </p>
                        <p>
                            The water charges and other charges incurred for lighting and ventilation
                        </p>
                        <p>
                            The interest and amount spend on the provision and maintenance of equipment provided for the canteen.
                        </p>
                        <p>
                            The accounts pertaining to the canteen shall be audited once every 12months by registered accountants and auditors.
                        </p>
                        <h3 id="section-107">
                            Anti-malarial precautions
                        </h3>
                        <p>
                            The contractor shall at its own expense, conform to all anti-malarial instructions given to him by Engineer-in-charge including the filing up of any borrow pits which may have been dug by him.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>