<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head();
$module_name = 'warehouse_goods_receipt';
?>
<style>
  .onoffswitch-label:before {

    height: 20px !important;
  }

  .n_width {
    width: 25% !important;
  }

  .dashboard_stat_title {
    font-size: 19px;
    font-weight: bold;
  }

  .dashboard_stat_value {
    font-size: 19px;
  }
</style>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="col-md-12" id="small-table">
        <div class="panel_s">
          <div class="panel-body">
            <?php echo form_hidden('purchase_id', $purchase_id); ?>
            <div class="row">
              <div class="col-md-12" style="padding: 0px;">
                <div class="col-md-12" id="heading">
                  <h4 class="no-margin font-bold"><i class="fa fa-shopping-basket" aria-hidden="true"></i> Stock Received</h4>
                  <hr />
                </div>
                <?php /* <div class="col-md-2 display-flex" id="filter_div">
                                    <label>PO Not received</label>
                                    <div class="onoffswitch" style="margin-left: 10px;">
                                        <input type="checkbox" name="toggle-filter" class="onoffswitch-checkbox toggle-filter" id="c_' . $aRow['staffid'] . '" value="0">
                                        <label class="onoffswitch-label" for="c_' . $aRow['staffid'] . '"></label>
                                    </div>

                                    <hr />
                                </div> */ ?>

              </div>

            </div>
            <div class="row">
              <div class="_buttons col-md-3">
                <?php if (has_permission('warehouse', '', 'create') || is_admin()) { ?>
                  <a href="<?php echo admin_url('warehouse/manage_goods_receipt'); ?>" class="btn btn-info pull-left mright10 display-block">
                    Add New
                  </a>
                <?php } ?>
                <button class="btn btn-info pull-left mleft10 display-block" type="button" data-toggle="collapse" data-target="#sr-charts-section" aria-expanded="true" aria-controls="sr-charts-section">
                  <?php echo _l('Stock Received Charts'); ?> <i class="fa fa-chevron-down toggle-icon"></i>
                </button>
              </div>
              <div class="col-md-1 pull-right">
                <a href="#" class="btn btn-default pull-right btn-with-tooltip toggle-small-view hidden-xs" onclick="toggle_small_view_proposal(' .purchase_sm','#purchase_sm_view'); return false;" data-toggle="tooltip" title="<?php echo _l('invoices_toggle_table_tooltip'); ?>"><i class="fa fa-angle-double-left"></i></a>
              </div>
            </div>

            <div id="sr-charts-section" class="collapse in">
              <div class="row">
                <div class="col-md-12 mtop20">
                  <div class="row">
                    <div class="quick-stats-invoices col-md-3 tw-mb-2 sm:tw-mb-0 n_width">
                      <div class="top_stats_wrapper">
                        <div class="tw-text-neutral-800 mtop5 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_title">Total Receipts (By period)</span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                        <div class="tw-text-neutral-800 mtop15 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_value total_receipts"></span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                      </div>
                    </div>
                    <div class="quick-stats-invoices col-md-3 tw-mb-2 sm:tw-mb-0 n_width">
                      <div class="top_stats_wrapper">
                        <div class="tw-text-neutral-800 mtop5 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_title">Received PO / Total PO</span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                        <div class="tw-text-neutral-800 mtop15 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_value total_received_po"></span> / <span class="tw-truncate dashboard_stat_value total_po"></span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                      </div>
                    </div>
                    <div class="quick-stats-invoices col-md-3 tw-mb-2 sm:tw-mb-0 n_width">
                      <div class="top_stats_wrapper">
                        <div class="tw-text-neutral-800 mtop5 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_title">Total Quantity Received</span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                        <div class="tw-text-neutral-800 mtop15 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_value total_quantity_received"></span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                      </div>
                    </div>
                    <div class="quick-stats-invoices col-md-3 tw-mb-2 sm:tw-mb-0 n_width">
                      <div class="top_stats_wrapper">
                        <div class="tw-text-neutral-800 mtop5 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_title">Client Supply / Bought out items</span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                        <div class="tw-text-neutral-800 mtop15 tw-flex tw-items-center tw-justify-between">
                          <div class="tw-font-medium tw-inline-flex text-neutral-600 tw-items-center tw-truncate">
                            <span class="tw-truncate dashboard_stat_value total_client_supply"></span> / <span class="tw-truncate dashboard_stat_value total_bought_out_items"></span>
                          </div>
                          <span class="tw-font-semibold tw-text-neutral-600 tw-shrink-0"></span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row mtop20">
                <div class="col-md-4">
                  <p class="mbot15 dashboard_stat_title">Receipts Over Time</p>
                  <div style="width: 100%; height: 400px;">
                    <canvas id="lineChartOverTime"></canvas>
                  </div>
                </div>
                <div class="col-md-4">
                  <p class="mbot15 dashboard_stat_title">Top 10 Suppliers by Receipts</p>
                  <div style="width: 100%; height: 400px;">
                    <canvas id="barChartTopVendors"></canvas>
                  </div>
                </div>
                <div class="col-md-4">
                  <p class="mbot15 dashboard_stat_title">Documentation Status</p>
                  <div style="width: 100%; height: 400px; display: flex;">
                    <canvas id="doughnutChartDocumentationStatus"></canvas>
                  </div>
                </div>
              </div>
            </div>

            <div class="row mtop20 all_ot_filters">
              <div class="col-md-3 form-group pull-right">
                <select name="kind" id="kind" class="selectpicker" data-live-search="true" data-width="100%" data-none-selected-text="<?php echo _l('cat'); ?>">
                  <?php
                  $kind_filter = get_module_filter($module_name, 'kind');
                  $kind_filter_val = !empty($kind_filter) ? explode(",", $kind_filter->filter_value) : [];
                  ?>
                  <option value=""></option>
                  <option value="Client Supply" <?php echo in_array('Client Supply', $kind_filter_val) ? 'selected' : ''; ?>>
                    <?php echo _l('client_supply'); ?>
                  </option>
                  <option value="Bought out items" <?php echo in_array('Bought out items', $kind_filter_val) ? 'selected' : ''; ?>>
                    <?php echo _l('bought_out_items'); ?>
                  </option>
                </select>
              </div>
              <div class="col-md-3 pull-right">
                <?php
                $input_attr_e = [];
                $input_attr_e['placeholder'] = _l('day_vouchers');

                $day_vouchers_filter = get_module_filter($module_name, 'day_vouchers');
                $day_vouchers_filter_val = !empty($day_vouchers_filter) ?  $day_vouchers_filter->filter_value : '';

                echo render_date_input('date_add', '', $day_vouchers_filter_val, $input_attr_e); ?>
              </div>
              <div class="col-md-3 form-group pull-right">
                <?php
                $vendor_type_filter = get_module_filter($module_name, 'vendor');
                $vendor_type_filter_val = !empty($vendor_type_filter) ? explode(",", $vendor_type_filter->filter_value) : [];
                ?>
                <select name="vendor[]" id="vendor" class="selectpicker" multiple="true" data-live-search="true" data-width="100%" data-none-selected-text="<?php echo _l('vendor'); ?>">
                  <?php
                  $vendor = get_pur_vendor_list();
                  foreach ($vendor as $vendors) {
                    $selected = in_array($vendors['userid'], $vendor_type_filter_val) ? 'selected' : '';
                  ?>
                    <option value="<?php echo $vendors['userid']; ?>" <?php echo $selected; ?>>
                      <?php echo $vendors['company']; ?>
                    </option>
                  <?php } ?>
                </select>

              </div>
              <?php
              $approval_status_type_filter = get_module_filter($module_name, 'status');
              $approval_status_type_filter_val = !empty($approval_status_type_filter) ? $approval_status_type_filter->filter_value : '';
              ?>

              <div class="col-md-3 form-group pull-right">
                <select name="status" id="status" class="selectpicker" data-live-search="true" data-width="100%" data-none-selected-text="<?php echo _l('status'); ?>">
                  <option value=""></option>
                  <option value="approved" <?= ($approval_status_type_filter_val === 'approved') ? 'selected' : '' ?>><?php echo _l('approved'); ?></option>
                  <option value="not_yet_approve" <?= ($approval_status_type_filter_val === 'not_yet_approve') ? 'selected' : '' ?>><?php echo _l('not_yet_approve'); ?></option>
                </select>
              </div>
              <div class="col-md-3 form-group" id="report-time">
                <?php
                $report_months_filter = get_module_filter($module_name, 'report_months');
                $report_months_filter_val = !empty($report_months_filter) ? $report_months_filter->filter_value : '';
                ?>
                <select class="selectpicker" name="months-report" id="months-report" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                  <option value="" <?php echo ($report_months_filter_val === '') ? 'selected' : ''; ?>><?php echo _l('report_sales_months_all_time'); ?></option>
                  <option value="this_month" <?php echo ($report_months_filter_val === 'this_month') ? 'selected' : ''; ?>><?php echo _l('this_month'); ?></option>
                  <option value="1" <?php echo ($report_months_filter_val === '1') ? 'selected' : ''; ?>><?php echo _l('last_month'); ?></option>
                  <option value="this_year" <?php echo ($report_months_filter_val === 'this_year') ? 'selected' : ''; ?>><?php echo _l('this_year'); ?></option>
                  <option value="last_year" <?php echo ($report_months_filter_val === 'last_year') ? 'selected' : ''; ?>><?php echo _l('last_year'); ?></option>
                  <option value="3" <?php echo ($report_months_filter_val === '3') ? 'selected' : ''; ?> data-subtext="<?php echo _d(date('Y-m-01', strtotime("-2 MONTH"))); ?> - <?php echo _d(date('Y-m-t')); ?>"><?php echo _l('report_sales_months_three_months'); ?></option>
                  <option value="6" <?php echo ($report_months_filter_val === '6') ? 'selected' : ''; ?> data-subtext="<?php echo _d(date('Y-m-01', strtotime("-5 MONTH"))); ?> - <?php echo _d(date('Y-m-t')); ?>"><?php echo _l('report_sales_months_six_months'); ?></option>
                  <option value="12" <?php echo ($report_months_filter_val === '12') ? 'selected' : ''; ?> data-subtext="<?php echo _d(date('Y-m-01', strtotime("-11 MONTH"))); ?> - <?php echo _d(date('Y-m-t')); ?>"><?php echo _l('report_sales_months_twelve_months'); ?></option>
                  <option value="custom" <?php echo ($report_months_filter_val === 'custom') ? 'selected' : ''; ?>><?php echo _l('period_datepicker'); ?></option>
                </select>
              </div>
              <div id="date-range" class="hide">
                <div class="col-md-3 form-group">
                  <div class="input-group date">
                    <input type="text" class="form-control datepicker" id="report-from" name="report-from">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar calendar-icon"></i>
                    </div>
                  </div>
                </div>
                <div class="col-md-3 form-group">
                  <div class="input-group date">
                    <input type="text" class="form-control datepicker" disabled="disabled" id="report-to" name="report-to">
                    <div class="input-group-addon">
                      <i class="fa fa-calendar calendar-icon"></i>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-3 form-group">
                <?php
                $wo_po_orders_filter = get_module_filter($module_name, 'wo_po_order');
                $wo_po_orders_filter_val = !empty($wo_po_orders_filter) ? explode(",", $wo_po_orders_filter->filter_value) : [];
                ?>
                <select name="wo_po_order[]" id="wo_po_order" multiple class="selectpicker" data-live-search="true" data-width="100%" data-none-selected-text="<?php echo _l('Choose From Order'); ?>">
                  <?php
                  $po_wo_orders = get_purchase_work_order();
                  foreach ($po_wo_orders as $key => $value) {
                    $option_value = $value['id'] . '-' . $value['type'] . '-' . $value['goods_id'];
                    $selected = in_array($option_value, $wo_po_orders_filter_val) ? 'selected' : '';
                    echo '<option value="' . $option_value . '" ' . $selected . '>' . $value['name'] . '</option>';
                  }
                  ?>
                </select>
              </div>
              <div class="row">
                <div class="col-md-1 form-group">
                  <a href="javascript:void(0)" class="btn btn-info btn-icon reset_all_ot_filters">
                    <?php echo _l('reset_filter'); ?>
                  </a>
                </div>
              </div>
            </div>

            <br />
            <?php render_datatable(array(
              _l('id'),
              _l('stock_received_docket_code'),
              _l('supplier_name'),
              _l('Prepared By'),
              _l('category'),
              _l('reference_order'),
              _l('Receive Date'),

              // _l('total_tax_money'),
              // _l('total_goods_money'),
              // _l('value_of_inventory'),
              // _l('total_money'),
              _l('status_label'),
              _l('options'),
            ), 'table_manage_goods_receipt', ['purchase_sm' => 'purchase_sm']); ?>

          </div>
        </div>
      </div>

      <div class="col-md-7 small-table-right-col">
        <div id="purchase_sm_view" class="hide">
        </div>
      </div>

    </div>
  </div>
</div>



<script>
  var hidden_columns = [3, 4, 5];
</script>
<?php init_tail(); ?>
<script src="<?php echo module_dir_url(PURCHASE_MODULE_NAME, 'assets/plugins/charts/chart.js'); ?>?v=<?php echo PURCHASE_REVISION; ?>"></script>
</body>

</html>